/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter.StonecutterRecipeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter.StonecutterUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class StonecutterUpgradeContainer
extends UpgradeContainerBase<StonecutterUpgradeWrapper, StonecutterUpgradeContainer> {
    private static final String DATA_SHIFT_CLICK_INTO_BACKPACK = "shiftClickIntoBackpack";
    private final StonecutterRecipeContainer recipeContainer;

    public StonecutterUpgradeContainer(Player player, int upgradeContainerId, StonecutterUpgradeWrapper upgradeWrapper, UpgradeContainerType<StonecutterUpgradeWrapper, StonecutterUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        ContainerLevelAccess worldPosCallable = player.f_19853_.f_46443_ ? ContainerLevelAccess.f_39287_ : ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)player.m_142538_());
        this.recipeContainer = new StonecutterRecipeContainer(this, this.slots::add, this, worldPosCallable);
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_SHIFT_CLICK_INTO_BACKPACK)) {
            this.setShiftClickIntoBackpack(data.m_128471_(DATA_SHIFT_CLICK_INTO_BACKPACK));
        } else {
            this.recipeContainer.handleMessage(data);
        }
    }

    public boolean shouldShiftClickIntoBackpack() {
        return ((StonecutterUpgradeWrapper)this.upgradeWrapper).shouldShiftClickIntoBackpack();
    }

    public void setShiftClickIntoBackpack(boolean shiftClickIntoBackpack) {
        ((StonecutterUpgradeWrapper)this.upgradeWrapper).setShiftClickIntoBackpack(shiftClickIntoBackpack);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundTag(), DATA_SHIFT_CLICK_INTO_BACKPACK, shiftClickIntoBackpack));
    }

    public StonecutterRecipeContainer getRecipeContainer() {
        return this.recipeContainer;
    }

    @Override
    public boolean mergeIntoBackpackFirst(Slot slot) {
        return this.recipeContainer.isNotResultSlot(slot) || this.shouldShiftClickIntoBackpack();
    }

    @Override
    public boolean allowsPickupAll(Slot slot) {
        return this.recipeContainer.isNotResultSlot(slot);
    }
}

