/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter.StonecutterUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class StonecutterUpgradeWrapper
extends UpgradeWrapperBase<StonecutterUpgradeWrapper, StonecutterUpgradeItem> {
    private static final String RECIPE_ID_TAG = "recipeId";
    private final IItemHandlerModifiable inputInventory;

    protected StonecutterUpgradeWrapper(IBackpackWrapper backpackWrapper, final ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.inputInventory = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (slot == 0) {
                    upgrade.m_41700_("input", (Tag)this.getStackInSlot(0).serializeNBT());
                }
            }
        };
        NBTHelper.getCompound(upgrade, "input").ifPresent(tag -> this.inputInventory.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)tag)));
    }

    public IItemHandlerModifiable getInputInventory() {
        return this.inputInventory;
    }

    public void setRecipeId(@Nullable ResourceLocation recipeId) {
        if (recipeId == null) {
            NBTHelper.removeTag(this.upgrade, RECIPE_ID_TAG);
            return;
        }
        this.upgrade.m_41700_(RECIPE_ID_TAG, (Tag)StringTag.m_129297_((String)recipeId.toString()));
        this.save();
    }

    public Optional<ResourceLocation> getRecipeId() {
        return NBTHelper.getString(this.upgrade, RECIPE_ID_TAG).map(ResourceLocation::new);
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    public boolean shouldShiftClickIntoBackpack() {
        return NBTHelper.getBoolean(this.upgrade, "shiftClickIntoBackpack").orElse(true);
    }

    public void setShiftClickIntoBackpack(boolean shiftClickIntoBackpack) {
        NBTHelper.setBoolean(this.upgrade, "shiftClickIntoBackpack", shiftClickIntoBackpack);
        this.save();
    }
}

