/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.UpgradeInventoryPartBase;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankClickMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeContainer;

public class TankInventoryPart
extends UpgradeInventoryPartBase<TankUpgradeContainer> {
    private static final TextureBlitData OVERLAY = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(47, 30), new Dimension(16, 18));
    private final Position pos;
    private final int height;
    private final BackpackScreen screen;

    public TankInventoryPart(int upgradeSlot, TankUpgradeContainer container, Position pos, int height, BackpackScreen screen) {
        super(upgradeSlot, container);
        this.pos = pos;
        this.height = height;
        this.screen = screen;
    }

    @Override
    public void render(PoseStack matrixStack, int mouseX, int mouseY) {
        int i;
        GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft(), this.pos.y(), GuiHelper.BAR_BACKGROUND_TOP);
        int yOffset = 18;
        for (i = 0; i < (this.height - 36) / 18; ++i) {
            GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft(), this.pos.y() + yOffset, GuiHelper.BAR_BACKGROUND_MIDDLE);
            yOffset += 18;
        }
        GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft(), this.pos.y() + yOffset, GuiHelper.BAR_BACKGROUND_BOTTOM);
        this.renderFluid(matrixStack, mouseX, mouseY);
        yOffset = 0;
        for (i = 0; i < this.height / 18; ++i) {
            GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft() + 1, this.pos.y() + yOffset, OVERLAY);
            yOffset += 18;
        }
    }

    private int getTankLeft() {
        return this.pos.x() + 9;
    }

    @Override
    public boolean handleMouseReleased(double mouseX, double mouseY, int button) {
        if (mouseX < (double)(this.screen.getGuiLeft() + this.getTankLeft()) || mouseX >= (double)(this.screen.getGuiLeft() + this.getTankLeft() + 18) || mouseY < (double)(this.screen.getGuiTop() + this.pos.y()) || mouseY >= (double)(this.screen.getGuiTop() + this.pos.y() + this.height)) {
            return false;
        }
        ItemStack cursorStack = ((BackpackContainer)this.screen.m_6262_()).m_142621_();
        if (!cursorStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return false;
        }
        PacketHandler.sendToServer(new TankClickMessage(this.upgradeSlot));
        return true;
    }

    @Override
    public void renderErrorOverlay(PoseStack matrixStack) {
        this.screen.renderOverlay(matrixStack, BackpackScreen.ERROR_SLOT_COLOR, this.getTankLeft() + 1, this.pos.y() + 1, 16, this.height - 2);
    }

    private void renderTooltip(int mouseX, int mouseY, FluidStack contents, int capacity) {
        int screenX = this.screen.getGuiLeft() + this.pos.x() + 10;
        int screenY = this.screen.getGuiTop() + this.pos.y() + 1;
        if (mouseX >= screenX && mouseX < screenX + 16 && mouseY >= screenY && mouseY < screenY + this.height - 2) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (!contents.isEmpty()) {
                tooltip.add(contents.getDisplayName());
            }
            tooltip.add(new TranslatableComponent(TranslationHelper.translUpgradeKey("tank.contents_tooltip"), new Object[]{String.format("%,d", contents.getAmount()), String.format("%,d", capacity)}));
            GuiHelper.setTooltipToRender(tooltip);
        }
    }

    private void renderFluid(PoseStack matrixStack, int mouseX, int mouseY) {
        FluidStack contents = ((TankUpgradeContainer)this.container).getContents();
        int capacity = ((TankUpgradeContainer)this.container).getTankCapacity();
        if (contents.isEmpty()) {
            this.renderTooltip(mouseX, mouseY, FluidStack.EMPTY, capacity);
            return;
        }
        Fluid fluid = contents.getFluid();
        int fill = contents.getAmount();
        int displayLevel = (int)((float)(this.height - 2) * ((float)fill / (float)capacity));
        ResourceLocation texture = fluid.getAttributes().getStillTexture(contents);
        TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        this.renderTiledFluidTextureAtlas(matrixStack, still, fluid.getAttributes().getColor(), this.pos.x() + 10, this.pos.y() + 1 + this.height - 2 - displayLevel, displayLevel);
        this.renderTooltip(mouseX, mouseY, contents, capacity);
    }

    private void renderTiledFluidTextureAtlas(PoseStack matrixStack, TextureAtlasSprite sprite, int color, int x, int y, int height) {
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.m_118414_().m_118330_());
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        float u1 = sprite.m_118409_();
        float v1 = sprite.m_118411_();
        int spriteHeight = sprite.m_118408_();
        int spriteWidth = sprite.m_118405_();
        int startY = y;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        do {
            int renderHeight = Math.min(spriteHeight, height);
            height -= renderHeight;
            float v2 = sprite.m_118393_((double)(16.0f * (float)renderHeight / (float)spriteHeight));
            Matrix4f matrix = matrixStack.m_85850_().m_85861_();
            float u2 = sprite.m_118367_((double)(256.0f / (float)spriteWidth));
            builder.m_85982_(matrix, (float)x, (float)startY + (float)renderHeight, 100.0f).m_7421_(u1, v2).m_85950_(red, green, blue, 1.0f).m_5752_();
            builder.m_85982_(matrix, (float)x + 16.0f, (float)startY + (float)renderHeight, 100.0f).m_7421_(u2, v2).m_85950_(red, green, blue, 1.0f).m_5752_();
            builder.m_85982_(matrix, (float)x + 16.0f, (float)startY, 100.0f).m_7421_(u2, v1).m_85950_(red, green, blue, 1.0f).m_5752_();
            builder.m_85982_(matrix, (float)x, (float)startY, 100.0f).m_7421_(u1, v1).m_85950_(red, green, blue, 1.0f).m_5752_();
            startY += renderHeight;
        } while (height > 0);
        builder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)builder);
    }
}

