/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper;

import java.util.Collections;
import java.util.HashSet;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedbackpacks.api.UpgradeType;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperUpgradeWrapper;

public class ToolSwapperUpgradeItem
extends UpgradeItemBase<ToolSwapperUpgradeWrapper> {
    private static final UpgradeType<ToolSwapperUpgradeWrapper> TYPE = new UpgradeType<ToolSwapperUpgradeWrapper>(ToolSwapperUpgradeWrapper::new);
    private final boolean hasSettingsTab;
    private final boolean swapToolOnKeyPress;

    public ToolSwapperUpgradeItem(boolean hasSettingsTab, boolean swapToolOnKeyPress) {
        this.hasSettingsTab = hasSettingsTab;
        this.swapToolOnKeyPress = swapToolOnKeyPress;
    }

    @Override
    public UpgradeType<ToolSwapperUpgradeWrapper> getType() {
        return TYPE;
    }

    public boolean hasSettingsTab() {
        return this.hasSettingsTab;
    }

    public boolean shouldSwapToolOnKeyPress() {
        return this.swapToolOnKeyPress;
    }

    @Override
    public UpgradeSlotChangeResult canAddUpgradeTo(IBackpackWrapper backpackWrapper, ItemStack upgradeStack, boolean firstLevelBackpack) {
        HashSet<Integer> errorUpgradeSlots = new HashSet<Integer>();
        backpackWrapper.getUpgradeHandler().getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof ToolSwapperUpgradeWrapper) {
                errorUpgradeSlots.add((Integer)slot);
            }
        });
        if (!errorUpgradeSlots.isEmpty()) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.translError("add.tool_swapper_exists", new Object[0]), errorUpgradeSlots, Collections.emptySet(), Collections.emptySet());
        }
        return new UpgradeSlotChangeResult.Success();
    }
}

