/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import io.github.cottonmc.jankson.JanksonFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.codexadrian.spirit.Spirit;
import me.codexadrian.spirit.SpiritClientConfig;
import me.codexadrian.spirit.blocks.soulcage.SoulCageRenderer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendereregistry.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

public class SpiritClient
implements ClientModInitializer {
    private static SpiritClientConfig clientConfig;
    public static final Jankson jankson;

    public void onInitializeClient() {
        try {
            clientConfig = SpiritClientConfig.loadConfig(FabricLoader.getInstance().getConfigDir());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)Spirit.SOUL_CAGE, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(Spirit.BROKEN_SPAWNER, class_1921.method_23581());
        BlockEntityRendererRegistry.INSTANCE.register(Spirit.SOUL_CAGE_ENTITY, SoulCageRenderer::new);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("spirit_reload");
            }

            public void method_14491(class_3300 resourceManager) {
            }
        });
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                int red = 196;
                int green = 255;
                int blue = 254;
                if (stack.method_7985()) {
                    float percentage = Math.min((float)stack.method_7969().method_10562("StoredEntity").method_10550("Souls") / (float)Spirit.getSpiritConfig().getMaxSouls(), 1.0f);
                    red = (int)((float)red - percentage * 91.0f);
                    green = (int)((float)green - percentage * 7.0f);
                    blue = (int)((float)blue + percentage);
                }
                return red << 16 | green << 8 | blue;
            }
            return -1;
        }, (Object[])new class_1935[]{Spirit.SOUL_CRYSTAL});
        FabricModelPredicateProviderRegistry.register((class_1792)Spirit.SOUL_CRYSTAL, (class_2960)new class_2960("spirit", "activation"), (stack, level, entity, seed) -> stack.method_7985() ? (float)Spirit.getTier(stack) / 4.0f : 0.0f);
    }

    public static SpiritClientConfig getClientConfig() {
        return clientConfig;
    }

    public static void saveConfig(SpiritClientConfig config) {
        try {
            Path file = FabricLoader.getInstance().getConfigDir().resolve("spirit_client.json");
            JsonElement json = jankson.toJson((Object)config);
            String result = json.toJson(true, true);
            Files.write(file, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        jankson = JanksonFactory.createJankson();
    }
}

