/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpiritClientConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @SerializedName(value="isShaderEnabled")
    private boolean isShaderEnabled = true;

    public boolean getShaderStatus() {
        return this.isShaderEnabled;
    }

    public void setShaderStatus(boolean newStatus) {
        this.isShaderEnabled = newStatus;
    }

    public static SpiritClientConfig loadConfig(Path configFolder) throws IOException {
        Path configPath = configFolder.resolve("spirit_client.json");
        if (!Files.exists(configPath, new LinkOption[0])) {
            SpiritClientConfig config = new SpiritClientConfig();
            try (FileWriter writer = new FileWriter(configPath.toFile());){
                GSON.toJson((Object)config, (Appendable)writer);
            }
            LOGGER.info("Created config file for mod spirit");
            return config;
        }
        return (SpiritClientConfig)GSON.fromJson((Reader)new InputStreamReader(Files.newInputStream(configPath, new OpenOption[0])), SpiritClientConfig.class);
    }
}

