/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpiritConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @SerializedName(value="requiredSouls")
    private int requiredSouls = 64;
    @SerializedName(value="tiers")
    private int tiers = 4;
    @SerializedName(value="minSpawnDelay")
    private int[] minSpawnDelay = new int[]{300, 150, 75, 25};
    @SerializedName(value="maxSpawnDelay")
    private int[] maxSpawnDelay = new int[]{1000, 600, 400, 300};
    @SerializedName(value="spawnCount")
    private int[] spawnCount = new int[]{3, 5, 7, 9};
    @SerializedName(value="spawnRange")
    private int[] spawnRange = new int[]{5, 7, 9, 11};
    @SerializedName(value="nearbyRange")
    private int[] nearbyRange = new int[]{16, 24, 32, -1};

    public int getRequiredSouls() {
        return this.requiredSouls;
    }

    public int getMaxSpawnDelay(int index) {
        return this.maxSpawnDelay[index];
    }

    public int getMinSpawnDelay(int index) {
        return this.minSpawnDelay[index];
    }

    public int getSpawnCount(int index) {
        return this.spawnCount[index];
    }

    public int getSpawnRange(int index) {
        return this.spawnRange[index];
    }

    public int getNearbyRange(int index) {
        return this.nearbyRange[index];
    }

    public int getMaxTierAmount() {
        return this.tiers > 0 ? Math.min(this.tiers, 4) : 1;
    }

    public int getMaxSouls() {
        return this.requiredSouls * this.getMaxTierAmount();
    }

    public static SpiritConfig loadConfig(Path configFolder) throws IOException {
        Path configPath = configFolder.resolve("spirit.json");
        if (!Files.exists(configPath, new LinkOption[0])) {
            SpiritConfig config = new SpiritConfig();
            try (FileWriter writer = new FileWriter(configPath.toFile());){
                GSON.toJson((Object)config, (Appendable)writer);
            }
            LOGGER.info("Created config file for mod spirit");
            return config;
        }
        return (SpiritConfig)GSON.fromJson((Reader)new InputStreamReader(Files.newInputStream(configPath, new OpenOption[0])), SpiritConfig.class);
    }
}

