/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.blocks.soulcage;

import java.util.Random;
import me.codexadrian.spirit.Corrupted;
import me.codexadrian.spirit.Spirit;
import me.codexadrian.spirit.blocks.soulcage.SoulCageBlock;
import me.codexadrian.spirit.blocks.soulcage.SoulCageBlockEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1317;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5425;

public class SoulCageSpawner {
    private double spin;
    private int spawnDelay = 20;
    private final SoulCageBlockEntity soulCageBlockEntity;

    public SoulCageSpawner(SoulCageBlockEntity entity) {
        this.soulCageBlockEntity = entity;
    }

    public void tick() {
        class_1937 level = this.getLevel();
        class_2338 blockPos = this.getPos();
        if (level.field_9236) {
            if (this.isNearPlayer()) {
                double d = (double)blockPos.method_10263() + level.field_9229.nextDouble();
                double e = (double)blockPos.method_10264() + level.field_9229.nextDouble();
                double f = (double)blockPos.method_10260() + level.field_9229.nextDouble();
                level.method_8406((class_2394)class_2398.field_23114, d, e, f, 0.0, 0.0, 0.0);
                level.method_8406((class_2394)class_2398.field_22246, d, e, f, 0.0, 0.0, 0.0);
                this.spin = (this.spin + 20.0) % 360.0;
            }
        } else if (this.isNearPlayer()) {
            int tier = (Integer)this.getLevel().method_8320(this.getPos()).method_11654((class_2769)SoulCageBlock.TIER) - 1;
            if (this.spawnDelay == -1) {
                this.delay(tier);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
                return;
            }
            boolean bl = false;
            int i = 0;
            while (true) {
                class_3218 serverLevel;
                double z;
                double y;
                if (i >= Spirit.getSpiritConfig().getSpawnCount(tier)) {
                    if (!bl) break;
                    this.delay(tier);
                    break;
                }
                if (this.soulCageBlockEntity.type == null) {
                    this.delay(tier);
                    return;
                }
                double x = (double)blockPos.method_10263() + (level.field_9229.nextDouble() - level.field_9229.nextDouble()) * (double)Spirit.getSpiritConfig().getSpawnRange(tier) + 0.5;
                if (level.method_18026(this.soulCageBlockEntity.type.method_17683(x, y = (double)(blockPos.method_10264() + level.field_9229.nextInt(3) - 1), z = (double)blockPos.method_10260() + (level.field_9229.nextDouble() - level.field_9229.nextDouble()) * (double)Spirit.getSpiritConfig().getSpawnRange(tier) + 0.5)) && class_1317.method_20638(this.soulCageBlockEntity.type, (class_5425)(serverLevel = (class_3218)level), (class_3730)class_3730.field_16469, (class_2338)new class_2338(x, y, z), (Random)level.method_8409())) {
                    class_1297 spawned = this.soulCageBlockEntity.type.method_5883(level);
                    if (spawned == null) {
                        this.delay(tier);
                        return;
                    }
                    ((Corrupted)spawned).setCorrupted();
                    spawned.method_5808(x, y, z, spawned.method_36454(), spawned.method_36455());
                    int l = level.method_18467(spawned.getClass(), new class_238(blockPos).method_1014((double)Spirit.getSpiritConfig().getSpawnRange(tier))).size();
                    if (l >= 6) {
                        this.delay(tier);
                        return;
                    }
                    spawned.method_5808(spawned.method_23317(), spawned.method_23318(), spawned.method_23321(), level.field_9229.nextFloat() * 360.0f, 0.0f);
                    if (spawned instanceof class_1308) {
                        class_1308 mob = (class_1308)spawned;
                        if (!mob.method_5979((class_1936)level, class_3730.field_16469) || !mob.method_5957((class_4538)level)) {
                            this.delay(tier);
                            return;
                        }
                        ((class_1308)spawned).method_5943((class_5425)serverLevel, level.method_8404(spawned.method_24515()), class_3730.field_16469, null, null);
                    }
                    if (!serverLevel.method_30736(spawned)) {
                        this.delay(tier);
                        return;
                    }
                    serverLevel.method_14199((class_2394)class_2398.field_23114, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), 20, 1.0, 1.0, 1.0, 0.0);
                    if (spawned instanceof class_1308) {
                        ((class_1308)spawned).method_5990();
                    }
                    bl = true;
                }
                ++i;
            }
        }
    }

    private boolean isNearPlayer() {
        class_2338 blockPos = this.getPos();
        class_2680 blockState = this.getLevel().method_8320(this.getPos());
        if (blockState.method_27852((class_2248)Spirit.SOUL_CAGE)) {
            int tier = (Integer)blockState.method_11654((class_2769)SoulCageBlock.TIER) - 1;
            if (Spirit.getSpiritConfig().getNearbyRange(tier) > 0) {
                return this.getLevel().method_18458((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, (double)Spirit.getSpiritConfig().getNearbyRange(tier));
            }
            return true;
        }
        return false;
    }

    private void delay(int tier) {
        this.spawnDelay = Spirit.getSpiritConfig().getMaxSpawnDelay(tier) <= Spirit.getSpiritConfig().getMinSpawnDelay(tier) ? Spirit.getSpiritConfig().getMinSpawnDelay(tier) : Spirit.getSpiritConfig().getMinSpawnDelay(tier) + this.getLevel().field_9229.nextInt(Spirit.getSpiritConfig().getMaxSpawnDelay(tier) - Spirit.getSpiritConfig().getMinSpawnDelay(tier));
        this.broadcastEvent(1);
    }

    public boolean onEventTriggered(int i) {
        if (i == 1 && this.getLevel().field_9236) {
            this.spawnDelay = Spirit.getSpiritConfig().getMinSpawnDelay((Integer)this.getLevel().method_8320(this.getPos()).method_11654((class_2769)SoulCageBlock.TIER));
            return true;
        }
        return false;
    }

    public void broadcastEvent(int i) {
        class_1937 level = this.soulCageBlockEntity.method_10997();
        if (level != null) {
            level.method_8427(this.soulCageBlockEntity.method_11016(), (class_2248)Spirit.SOUL_CAGE, i, 0);
        }
    }

    public class_1937 getLevel() {
        return this.soulCageBlockEntity.method_10997();
    }

    public class_2338 getPos() {
        return this.soulCageBlockEntity.method_11016();
    }

    public double getSpin() {
        return this.spin;
    }
}

