/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import toughasnails.api.potion.TANEffects;
import toughasnails.potion.ThirstEffect;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModPotions {
    @SubscribeEvent
    public static void registerEffects(RegistryEvent.Register<MobEffect> event) {
        ModPotions.register("thirst", new ThirstEffect(MobEffectCategory.HARMFUL, 7789388));
        ModPotions.register("ice_resistance", new MobEffect(MobEffectCategory.BENEFICIAL, 7842303));
        ModPotions.register("climate_clemency", new MobEffect(MobEffectCategory.NEUTRAL, 0xB6B6B6));
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        ModPotions.register("ice_resistance", new Potion(new MobEffectInstance[]{new MobEffectInstance(TANEffects.ICE_RESISTANCE, 1200)}));
        ModPotions.register("long_ice_resistance", new Potion(new MobEffectInstance[]{new MobEffectInstance(TANEffects.ICE_RESISTANCE, 2400)}));
    }

    public static void register(String name, MobEffect effect) {
        effect.setRegistryName(name);
        ForgeRegistries.MOB_EFFECTS.register((IForgeRegistryEntry)effect);
    }

    public static void register(String name, Potion potion) {
        potion.setRegistryName(name);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)potion);
    }
}

