/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.ModList;
import sereneseasons.season.SeasonHooks;
import toughasnails.api.capability.TANCapabilities;
import toughasnails.api.enchantment.TANEnchantments;
import toughasnails.api.temperature.IPlayerTemperatureModifier;
import toughasnails.api.temperature.IPositionalTemperatureModifier;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.config.ServerConfig;
import toughasnails.config.TemperatureConfig;
import toughasnails.init.ModTags;

public class TemperatureHelperImpl
implements TemperatureHelper.Impl.ITemperatureHelper {
    protected static List<IPositionalTemperatureModifier> positionalModifiers = Lists.newArrayList((Object[])new IPositionalTemperatureModifier[]{TemperatureHelperImpl::altitudeModifier});
    protected static List<IPlayerTemperatureModifier> playerModifiers = Lists.newArrayList((Object[])new IPlayerTemperatureModifier[]{TemperatureHelperImpl::immersionModifier});
    private static ITemperature lastTemperature;
    private static final int PROXIMITY_RADIUS;

    @Override
    public TemperatureLevel getTemperatureAtPos(Level level, BlockPos pos) {
        TemperatureLevel temperature = TemperatureHelperImpl.getBiomeTemperatureLevel(level, pos);
        for (IPositionalTemperatureModifier modifier : positionalModifiers) {
            temperature = modifier.modify(level, pos, temperature);
        }
        temperature = TemperatureHelperImpl.nightModifier(level, pos, temperature);
        return TemperatureHelperImpl.proximityModifier(level, pos, temperature);
    }

    @Override
    public ITemperature getPlayerTemperature(Player player) {
        ITemperature temperature;
        lastTemperature = temperature = (ITemperature)player.getCapability(TANCapabilities.TEMPERATURE).orElse((Object)lastTemperature);
        return temperature;
    }

    @Override
    public boolean isTemperatureEnabled() {
        return (Boolean)ServerConfig.enableTemperature.get();
    }

    @Override
    public void setTicksHyperthermic(Player player, int ticks) {
        this.getPlayerTemperature(player).setHyperthermiaTicks(ticks);
    }

    @Override
    public float getPercentHyperthermic(Player player) {
        int i = this.getTicksRequiredForHyperthermia();
        return (float)Math.min(this.getTicksHyperthermic(player), i) / (float)i;
    }

    @Override
    public boolean isFullyHyperthermic(Player player) {
        return this.getTicksHyperthermic(player) >= this.getTicksRequiredForHyperthermia();
    }

    @Override
    public int getTicksRequiredForHyperthermia() {
        return 140;
    }

    @Override
    public int getTicksHyperthermic(Player player) {
        return this.getPlayerTemperature(player).getHyperthermiaTicks();
    }

    @Override
    public void registerPlayerTemperatureModifier(IPlayerTemperatureModifier modifier) {
        playerModifiers.add(modifier);
    }

    @Override
    public void registerPositionalTemperatureModifier(IPositionalTemperatureModifier modifier) {
        positionalModifiers.add(modifier);
    }

    private static TemperatureLevel getBiomeTemperatureLevel(Level level, BlockPos pos) {
        Holder biome = level.m_204166_(pos);
        float biomeTemperature = ((Biome)biome.m_203334_()).m_47554_();
        if (pos.m_123342_() > (Integer)TemperatureConfig.environmentalModifierAltitude.get() || level.m_45527_(pos)) {
            if (biomeTemperature < 0.15f) {
                return TemperatureLevel.ICY;
            }
            if (biomeTemperature >= 0.15f && biomeTemperature < 0.45f) {
                return TemperatureLevel.COLD;
            }
            if (biomeTemperature >= 0.45f && biomeTemperature < 0.75f) {
                return TemperatureLevel.NEUTRAL;
            }
            if (biomeTemperature >= 0.75f && biomeTemperature < 0.9f) {
                return TemperatureLevel.WARM;
            }
            if (biomeTemperature >= 0.9f) {
                return TemperatureLevel.HOT;
            }
        }
        return TemperatureLevel.NEUTRAL;
    }

    private static TemperatureLevel altitudeModifier(Level level, BlockPos pos, TemperatureLevel current) {
        if (pos.m_123342_() > (Integer)TemperatureConfig.temperatureDropAltitude.get()) {
            current = current.decrement(1);
        } else if (pos.m_123342_() < (Integer)TemperatureConfig.temperatureRiseAltitude.get()) {
            current = current.increment(1);
        }
        return current;
    }

    private static TemperatureLevel nightModifier(Level level, BlockPos pos, TemperatureLevel current) {
        if (level.m_46462_() && (pos.m_123342_() > (Integer)TemperatureConfig.environmentalModifierAltitude.get() || level.m_45527_(pos))) {
            if (current == TemperatureLevel.HOT) {
                current = current.increment((Integer)TemperatureConfig.nightHotTemperatureChange.get());
            } else if (current != TemperatureLevel.NEUTRAL) {
                current = current.increment((Integer)TemperatureConfig.nightTemperatureChange.get());
            }
        }
        return current;
    }

    private static TemperatureLevel proximityModifier(Level level, BlockPos pos, TemperatureLevel current) {
        HashSet heating = Sets.newHashSet();
        HashSet cooling = Sets.newHashSet();
        TemperatureHelperImpl.fill(heating, cooling, level, pos);
        if (heating.size() > cooling.size()) {
            current = current.increment(1);
        } else if (cooling.size() > heating.size()) {
            current = current.decrement(1);
        }
        return current;
    }

    private static void fill(Set<BlockPos> heating, Set<BlockPos> cooling, Level level, BlockPos pos) {
        HashSet checked = Sets.newHashSet();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        int minX = pos.m_123341_() - PROXIMITY_RADIUS;
        int maxX = pos.m_123341_() + PROXIMITY_RADIUS;
        queue.add(pos);
        while (!queue.isEmpty()) {
            BlockPos posToCheck = (BlockPos)queue.poll();
            if (checked.contains(posToCheck)) continue;
            if (level.m_46859_(posToCheck)) {
                BlockPos westPos = posToCheck;
                BlockPos eastPos = posToCheck.m_142126_();
                while (level.m_46859_(westPos) && westPos.m_123341_() >= minX) {
                    checked.add(westPos);
                    TemperatureHelperImpl.expand(queue, checked, heating, cooling, level, pos, westPos);
                    westPos = westPos.m_142125_();
                }
                while (level.m_46859_(eastPos) && eastPos.m_123341_() <= maxX) {
                    checked.add(eastPos);
                    TemperatureHelperImpl.expand(queue, checked, heating, cooling, level, pos, eastPos);
                    eastPos = eastPos.m_142126_();
                }
                if (level.m_46859_(westPos)) {
                    checked.add(westPos);
                } else {
                    TemperatureHelperImpl.addHeatingOrCooling(checked, heating, cooling, level, westPos);
                }
                if (level.m_46859_(eastPos)) {
                    checked.add(eastPos);
                    continue;
                }
                TemperatureHelperImpl.addHeatingOrCooling(checked, heating, cooling, level, eastPos);
                continue;
            }
            TemperatureHelperImpl.addHeatingOrCooling(checked, heating, cooling, level, posToCheck);
        }
    }

    private static void expand(Queue<BlockPos> queue, Set<BlockPos> checked, Set<BlockPos> heating, Set<BlockPos> cooling, Level level, BlockPos origin, BlockPos pos) {
        BlockPos north = pos.m_142127_();
        BlockPos south = pos.m_142128_();
        BlockPos down = pos.m_7495_();
        BlockPos up = pos.m_7494_();
        int minZ = origin.m_123343_() - PROXIMITY_RADIUS;
        int maxZ = origin.m_123343_() + PROXIMITY_RADIUS;
        int minY = origin.m_123342_() - PROXIMITY_RADIUS;
        int maxY = origin.m_123342_() + PROXIMITY_RADIUS;
        if (north.m_123343_() >= minZ) {
            if (level.m_46859_(north)) {
                queue.add(north);
            } else {
                TemperatureHelperImpl.addHeatingOrCooling(checked, heating, cooling, level, north);
            }
        }
        if (south.m_123343_() <= maxZ) {
            if (level.m_46859_(south)) {
                queue.add(south);
            } else {
                TemperatureHelperImpl.addHeatingOrCooling(checked, heating, cooling, level, south);
            }
        }
        if (down.m_123342_() >= minY) {
            if (level.m_46859_(down)) {
                queue.add(down);
            } else {
                TemperatureHelperImpl.addHeatingOrCooling(checked, heating, cooling, level, down);
            }
        }
        if (up.m_123342_() <= maxY) {
            if (level.m_46859_(up)) {
                queue.add(up);
            } else {
                TemperatureHelperImpl.addHeatingOrCooling(checked, heating, cooling, level, up);
            }
        }
    }

    private static void addHeatingOrCooling(Set<BlockPos> checked, Set<BlockPos> heating, Set<BlockPos> cooling, Level level, BlockPos pos) {
        checked.add(pos);
        BlockState state = level.m_8055_(pos);
        if (state.m_204336_(ModTags.Blocks.HEATING_BLOCKS) && (!state.m_61138_((Property)CampfireBlock.f_51227_) || ((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue())) {
            heating.add(pos);
        } else if (state.m_204336_(ModTags.Blocks.COOLING_BLOCKS)) {
            cooling.add(pos);
        }
    }

    private static TemperatureLevel immersionModifier(Player player, TemperatureLevel current) {
        Level level = player.f_19853_;
        BlockPos pos = player.m_142538_();
        if (player.m_6060_()) {
            current = current.increment((Integer)TemperatureConfig.onFireTemperatureChange.get());
        }
        if (player.f_146808_) {
            current = current.increment((Integer)TemperatureConfig.powderSnowTemperatureChange.get());
        }
        if (player.m_20070_() || level.m_6425_(pos).m_205070_(FluidTags.f_13131_) || level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_)) {
            current = current.increment((Integer)TemperatureConfig.wetTemperatureChange.get());
        }
        if (player.f_19853_.m_46471_() && player.f_19853_.m_45527_(pos)) {
            Holder biome = player.f_19853_.m_204166_(pos);
            if (ModList.get().isLoaded("sereneseasons")) {
                if (!SeasonHooks.warmEnoughToRainHook((Holder)biome, (BlockPos)pos, (Level)player.f_19853_)) {
                    current = current.increment((Integer)TemperatureConfig.snowTemperatureChange.get());
                }
            } else if (((Biome)biome.m_203334_()).m_198904_(pos)) {
                current = current.increment((Integer)TemperatureConfig.snowTemperatureChange.get());
            }
        }
        return current;
    }

    protected static TemperatureLevel handheldModifier(Player player, TemperatureLevel current) {
        AtomicInteger coolingItems = new AtomicInteger();
        AtomicInteger heatingItems = new AtomicInteger();
        player.m_6167_().forEach(stack -> {
            if (stack.m_204117_(ModTags.Items.COOLING_ITEMS)) {
                coolingItems.getAndIncrement();
            }
            if (stack.m_204117_(ModTags.Items.HEATING_ITEMS)) {
                heatingItems.getAndIncrement();
            }
        });
        return current.increment(heatingItems.get() - coolingItems.get());
    }

    protected static TemperatureLevel armorModifier(Player player, TemperatureLevel current) {
        AtomicInteger coolingPieces = new AtomicInteger();
        AtomicInteger heatingPieces = new AtomicInteger();
        player.m_6168_().forEach(stack -> {
            if (stack.m_204117_(ModTags.Items.COOLING_ARMOR)) {
                coolingPieces.getAndIncrement();
            }
            if (stack.m_204117_(ModTags.Items.HEATING_ARMOR)) {
                heatingPieces.getAndIncrement();
            }
        });
        TemperatureLevel armorAdjTemp = current.increment(heatingPieces.get() / 2 - coolingPieces.get() / 2);
        current = armorAdjTemp == TemperatureLevel.HOT && current != TemperatureLevel.HOT ? armorAdjTemp.decrement(1) : (armorAdjTemp == TemperatureLevel.ICY && current != TemperatureLevel.ICY ? armorAdjTemp.increment(1) : armorAdjTemp);
        if (EnchantmentHelper.m_44836_((Enchantment)TANEnchantments.THERMAL_TUNING, (LivingEntity)player) > 0) {
            current = TemperatureLevel.NEUTRAL;
        }
        return current;
    }

    static {
        PROXIMITY_RADIUS = (Integer)TemperatureConfig.nearHeatCoolProximity.get();
    }
}

