/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.thirst;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import toughasnails.api.thirst.IThirst;
import toughasnails.config.ServerConfig;

public class ThirstCapabilityProvider
implements INBTSerializable<CompoundTag>,
ICapabilityProvider {
    private Capability<IThirst> capability;
    private IThirst instance;

    public ThirstCapabilityProvider(Capability capability, IThirst instance) {
        this.capability = capability;
        this.instance = instance;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == this.capability ? LazyOptional.of(() -> this.instance).cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        if (((Boolean)ServerConfig.enableThirst.get()).booleanValue()) {
            compound.m_128405_("thirstLevel", this.instance.getThirst());
            compound.m_128405_("thirstTickTimer", this.instance.getTickTimer());
            compound.m_128350_("thirstHydrationLevel", this.instance.getHydration());
            compound.m_128350_("thirstExhaustionLevel", this.instance.getExhaustion());
        } else {
            compound.m_128405_("thirstLevel", 20);
            compound.m_128405_("thirstTickTimer", 0);
            compound.m_128350_("thirstHydrationLevel", 2.0f);
            compound.m_128350_("thirstExhaustionLevel", 0.0f);
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_("thirstLevel", 99)) {
            if (((Boolean)ServerConfig.enableThirst.get()).booleanValue()) {
                this.instance.setThirst(nbt.m_128451_("thirstLevel"));
                this.instance.setTickTimer(nbt.m_128451_("thirstTickTimer"));
                this.instance.setHydration(nbt.m_128457_("thirstHydrationLevel"));
                this.instance.setExhaustion(nbt.m_128457_("thirstExhaustionLevel"));
            } else {
                this.instance.setThirst(20);
                this.instance.setTickTimer(0);
                this.instance.setHydration(2.0f);
                this.instance.setExhaustion(0.0f);
            }
        }
    }
}

