/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import toughasnails.api.capability.TANCapabilities;
import toughasnails.api.damagesource.TANDamageSources;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.temperature.IPlayerTemperatureModifier;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.config.ServerConfig;
import toughasnails.config.TemperatureConfig;
import toughasnails.network.MessageUpdateTemperature;
import toughasnails.network.PacketHandler;
import toughasnails.temperature.TemperatureCapabilityProvider;
import toughasnails.temperature.TemperatureData;
import toughasnails.temperature.TemperatureHelperImpl;

public class TemperatureHandler {
    private static final UUID SPEED_MODIFIER_HYPERTHERMIA_UUID = UUID.fromString("30b6ca4e-c6df-4532-80db-1d024765b56b");

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("toughasnails", "temperature"), (ICapabilityProvider)new TemperatureCapabilityProvider(TANCapabilities.TEMPERATURE, new TemperatureData()));
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().f_19853_.m_5776_()) {
            return;
        }
        TemperatureHandler.syncTemperature((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.getEntity().f_19853_.m_5776_()) {
            return;
        }
        TemperatureHandler.syncTemperature((ServerPlayer)event.getEntity());
        if (!((Boolean)TemperatureConfig.climateClemencyRespawning.get()).booleanValue()) {
            event.getEntity().getPersistentData().m_128379_("climateClemencyGranted", event.getOriginal().getPersistentData().m_128471_("climateClemencyGranted"));
        }
    }

    @SubscribeEvent
    public void onPlayerSpawn(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_() || !(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        CompoundTag data = player.getPersistentData();
        if (((Boolean)ServerConfig.enableTemperature.get()).booleanValue() && (Integer)TemperatureConfig.climateClemencyDuration.get() > 0 && !data.m_128471_("climateClemencyGranted") && !player.m_7500_()) {
            data.m_128379_("climateClemencyGranted", true);
            player.m_7292_(new MobEffectInstance((MobEffect)TANEffects.CLIMATE_CLEMENCY.get(), ((Integer)TemperatureConfig.climateClemencyDuration.get()).intValue(), 0, false, false, true));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!((Boolean)ServerConfig.enableTemperature.get()).booleanValue() || event.player.f_19853_.m_5776_()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        ITemperature data = TemperatureHelper.getTemperatureData((Player)player);
        data.setChangeDelayTicks(Math.max(0, data.getChangeDelayTicks() - 1));
        if (!player.m_21023_((MobEffect)TANEffects.CLIMATE_CLEMENCY.get())) {
            TemperatureLevel armorTargetLevel;
            TemperatureLevel itemTargetLevel;
            TemperatureLevel positionalTargetLevel;
            int changeDelay = (Integer)TemperatureConfig.temperatureChangeDelay.get();
            TemperatureLevel currentTargetLevel = data.getTargetLevel();
            TemperatureLevel newTargetLevel = positionalTargetLevel = TemperatureHelper.getTemperatureAtPos((Level)player.m_9236_(), player.m_20183_());
            for (IPlayerTemperatureModifier modifier : TemperatureHelperImpl.playerModifiers) {
                newTargetLevel = modifier.modify((Player)player, newTargetLevel);
            }
            if (newTargetLevel != positionalTargetLevel) {
                changeDelay = Math.min(changeDelay, (Integer)TemperatureConfig.playerTemperatureChangeDelay.get());
            }
            if ((itemTargetLevel = TemperatureHelperImpl.handheldModifier((Player)player, newTargetLevel)) != newTargetLevel) {
                changeDelay = Math.min(changeDelay, (Integer)TemperatureConfig.handheldTemperatureChangeDelay.get());
            }
            if ((armorTargetLevel = TemperatureHelperImpl.armorModifier((Player)player, newTargetLevel = itemTargetLevel)) != newTargetLevel) {
                changeDelay = Math.min(changeDelay, (Integer)TemperatureConfig.armorTemperatureChangeDelay.get());
            }
            if ((newTargetLevel = armorTargetLevel) != currentTargetLevel) {
                data.setTargetLevel(newTargetLevel);
                if ((data.getLevel() == TemperatureLevel.ICY || data.getLevel() == TemperatureLevel.HOT) && newTargetLevel != TemperatureLevel.ICY && newTargetLevel != TemperatureLevel.HOT) {
                    changeDelay = Math.min(changeDelay, (Integer)TemperatureConfig.extremityReboundTemperatureChangeDelay.get());
                }
                data.setChangeDelayTicks(changeDelay);
            }
            if (data.getChangeDelayTicks() == 0 && currentTargetLevel != data.getLevel()) {
                data.setLevel(data.getLevel().increment(Mth.m_14205_((double)(data.getTargetLevel().ordinal() - data.getLevel().ordinal()))));
                data.setChangeDelayTicks(changeDelay);
            }
        } else {
            data.setLevel(TemperatureLevel.NEUTRAL);
        }
        data.setExtremityDelayTicks(Math.max(0, data.getExtremityDelayTicks() - 1));
        if (data.getLastLevel() != data.getLevel() && (data.getLevel() == TemperatureLevel.ICY || data.getLevel() == TemperatureLevel.HOT)) {
            data.setExtremityDelayTicks((Integer)TemperatureConfig.extremityDamageDelay.get());
        }
        int hyperthermicTicks = data.getHyperthermiaTicks();
        int ticksToHyperthermia = TemperatureHelper.getTicksRequiredForHyperthermia();
        if (!player.m_7500_() && !player.m_5833_()) {
            int ticksToFreeze;
            int frozenTicks;
            if (!player.m_21023_((MobEffect)TANEffects.ICE_RESISTANCE.get()) && data.getLevel() == TemperatureLevel.ICY && data.getExtremityDelayTicks() == 0 && (frozenTicks = player.m_146888_()) < (ticksToFreeze = player.m_146891_() + 2)) {
                player.m_146917_(Math.min(ticksToFreeze, player.m_146888_() + 2));
            }
            if (!player.m_21023_(MobEffects.f_19607_) && data.getLevel() == TemperatureLevel.HOT && data.getExtremityDelayTicks() == 0) {
                data.setHyperthermiaTicks(Math.min(ticksToHyperthermia, hyperthermicTicks + 1));
                if (player.m_146888_() > 0) {
                    player.m_146917_(Math.max(0, player.m_146888_() - 2));
                }
            } else {
                data.setHyperthermiaTicks(Math.max(0, hyperthermicTicks - 2));
            }
        } else if (data.getHyperthermiaTicks() > 0) {
            data.setHyperthermiaTicks(Math.max(0, hyperthermicTicks - 2));
        }
        if (player.m_21023_((MobEffect)TANEffects.ICE_RESISTANCE.get()) && player.m_146888_() > 0) {
            player.m_146917_(0);
        }
        if (data.getLastLevel() != data.getLevel() || data.getLastHyperthermiaTicks() != data.getHyperthermiaTicks()) {
            TemperatureHandler.syncTemperature(player);
        }
        TemperatureHandler.removeHeatExhaustion(player);
        this.tryAddHeatExhaustion(player);
        if (player.f_19797_ % 40 == 0 && TemperatureHelper.isFullyHyperthermic((Player)player)) {
            player.m_6469_(TANDamageSources.HYPERTHERMIA, 1.0f);
        }
    }

    private static void syncTemperature(ServerPlayer player) {
        ITemperature temperature = TemperatureHelper.getTemperatureData((Player)player);
        temperature.setLastLevel(temperature.getLevel());
        temperature.setLastHyperthermiaTicks(temperature.getHyperthermiaTicks());
        PacketHandler.HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageUpdateTemperature(temperature.getLevel(), temperature.getHyperthermiaTicks()));
    }

    private static void removeHeatExhaustion(ServerPlayer player) {
        AttributeInstance attribute = player.m_21051_(Attributes.f_22279_);
        if (attribute != null && attribute.m_22111_(SPEED_MODIFIER_HYPERTHERMIA_UUID) != null) {
            attribute.m_22120_(SPEED_MODIFIER_HYPERTHERMIA_UUID);
        }
    }

    protected void tryAddHeatExhaustion(ServerPlayer player) {
        int ticks;
        if (!player.f_19853_.m_8055_(player.m_20097_()).m_60795_() && (ticks = TemperatureHelper.getTicksHyperthermic((Player)player)) > 0) {
            AttributeInstance attributeinstance = player.m_21051_(Attributes.f_22279_);
            if (attributeinstance == null) {
                return;
            }
            float f = 0.015f * TemperatureHelper.getPercentHyperthermic((Player)player);
            attributeinstance.m_22118_(new AttributeModifier(SPEED_MODIFIER_HYPERTHERMIA_UUID, "Hyperthermia slow", (double)f, AttributeModifier.Operation.ADDITION));
        }
    }
}

