/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.api.temperature;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import toughasnails.api.temperature.IPlayerTemperatureModifier;
import toughasnails.api.temperature.IPositionalTemperatureModifier;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureLevel;

public class TemperatureHelper {
    public static TemperatureLevel getTemperatureAtPos(Level level, BlockPos pos) {
        return Impl.INSTANCE.getTemperatureAtPos(level, pos);
    }

    public static TemperatureLevel getTemperatureForPlayer(Player player) {
        return TemperatureHelper.getTemperatureData(player).getLevel();
    }

    public static ITemperature getTemperatureData(Player player) {
        return Impl.INSTANCE.getPlayerTemperature(player);
    }

    public static void setTicksHyperthermic(Player player, int ticks) {
        Impl.INSTANCE.setTicksHyperthermic(player, ticks);
    }

    public static float getPercentHyperthermic(Player player) {
        return Impl.INSTANCE.getPercentHyperthermic(player);
    }

    public static boolean isFullyHyperthermic(Player player) {
        return Impl.INSTANCE.isFullyHyperthermic(player);
    }

    public static int getTicksRequiredForHyperthermia() {
        return Impl.INSTANCE.getTicksRequiredForHyperthermia();
    }

    public static int getTicksHyperthermic(Player player) {
        return Impl.INSTANCE.getTicksHyperthermic(player);
    }

    public static void registerPlayerTemperatureModifier(IPlayerTemperatureModifier modifier) {
        Impl.INSTANCE.registerPlayerTemperatureModifier(modifier);
    }

    public static void registerPositionalTemperatureModifier(IPositionalTemperatureModifier modifier) {
        Impl.INSTANCE.registerPositionalTemperatureModifier(modifier);
    }

    public static boolean isTemperatureEnabled() {
        return Impl.INSTANCE.isTemperatureEnabled();
    }

    public static class Impl {
        public static ITemperatureHelper INSTANCE = null;

        public static interface ITemperatureHelper {
            public TemperatureLevel getTemperatureAtPos(Level var1, BlockPos var2);

            public ITemperature getPlayerTemperature(Player var1);

            public void setTicksHyperthermic(Player var1, int var2);

            public float getPercentHyperthermic(Player var1);

            public boolean isFullyHyperthermic(Player var1);

            public int getTicksRequiredForHyperthermia();

            public int getTicksHyperthermic(Player var1);

            public void registerPlayerTemperatureModifier(IPlayerTemperatureModifier var1);

            public void registerPositionalTemperatureModifier(IPositionalTemperatureModifier var1);

            public boolean isTemperatureEnabled();
        }
    }
}

