/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.core;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toughasnails.api.block.TANBlocks;
import toughasnails.api.item.TANItems;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.thirst.IThirst;
import toughasnails.core.ClientProxy;
import toughasnails.core.CommonProxy;
import toughasnails.init.ModApi;
import toughasnails.init.ModBlockEntities;
import toughasnails.init.ModBlocks;
import toughasnails.init.ModCompatibility;
import toughasnails.init.ModConfig;
import toughasnails.init.ModContainerTypes;
import toughasnails.init.ModCrafting;
import toughasnails.init.ModEnchantments;
import toughasnails.init.ModHandlers;
import toughasnails.init.ModItems;
import toughasnails.init.ModPotions;
import toughasnails.init.ModTags;
import toughasnails.network.PacketHandler;

@Mod(value="toughasnails")
public class ToughAsNails {
    public static final String MOD_ID = "toughasnails";
    public static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)"toughasnails");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256922_, (String)"toughasnails");
    public static final DeferredRegister<MenuType<?>> MENU_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256798_, (String)"toughasnails");
    public static final DeferredRegister<Enchantment> ENCHANTMENT_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256762_, (String)"toughasnails");
    public static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"toughasnails");
    public static final DeferredRegister<MobEffect> MOB_EFFECT_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256929_, (String)"toughasnails");
    public static final DeferredRegister<Potion> POTION_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256973_, (String)"toughasnails");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256764_, (String)"toughasnails");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256954_, (String)"toughasnails");
    public static CommonProxy proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    public static final Logger LOGGER = LogManager.getLogger((String)"toughasnails");

    public ToughAsNails() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::registerCapabilities);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::loadComplete);
        bus.addListener(this::registerTab);
        BLOCK_REGISTER.register(bus);
        BLOCK_ENTITY_REGISTER.register(bus);
        ENCHANTMENT_REGISTER.register(bus);
        ITEM_REGISTER.register(bus);
        MENU_REGISTER.register(bus);
        MOB_EFFECT_REGISTER.register(bus);
        POTION_REGISTER.register(bus);
        RECIPE_SERIALIZER_REGISTER.register(bus);
        RECIPE_TYPE_REGISTER.register(bus);
        ModConfig.init();
        ModBlocks.init();
        ModContainerTypes.init();
        ModBlockEntities.init();
        ModEnchantments.init();
        ModItems.init();
        ModPotions.init();
        ModCrafting.init();
        PacketHandler.init();
        ModHandlers.init();
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IThirst.class);
        event.register(ITemperature.class);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ModApi.init());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ModContainerTypes.registerScreens());
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            proxy.init();
            ModCrafting.registerPotionRecipes();
            ModTags.init();
            ModCompatibility.init();
        });
    }

    private void registerTab(CreativeModeTabEvent.Register event) {
        List<RegistryObject<Item>> itemBlacklist = List.of(TANItems.TAN_ICON);
        List blockBlacklist = List.of();
        event.registerCreativeModeTab(new ResourceLocation(MOD_ID, "main"), builder -> builder.m_257737_(() -> new ItemStack((ItemLike)TANItems.TAN_ICON.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.toughasnails")).m_257501_((featureFlags, output, hasOp) -> {
            for (Field field : TANItems.class.getFields()) {
                if (field.getType() != RegistryObject.class) continue;
                try {
                    RegistryObject item = (RegistryObject)field.get(null);
                    if (itemBlacklist.contains(item)) continue;
                    output.m_246342_(new ItemStack((ItemLike)item.get()));
                }
                catch (IllegalAccessException item) {
                    // empty catch block
                }
            }
            for (Field field : TANBlocks.class.getFields()) {
                if (field.getType() != RegistryObject.class) continue;
                try {
                    RegistryObject block = (RegistryObject)field.get(null);
                    if (blockBlacklist.contains(block)) continue;
                    output.m_246342_(new ItemStack((ItemLike)block.get()));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }));
    }
}

