/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.crafting;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import toughasnails.api.crafting.TANRecipeSerializers;
import toughasnails.api.crafting.TANRecipeTypes;

public class WaterPurifierRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final StrictNBTIngredient ingredient;
    protected final ItemStack result;
    protected final int purifyTime;

    public WaterPurifierRecipe(ResourceLocation id, StrictNBTIngredient ingredient, ItemStack result, int purifyTime) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.purifyTime = purifyTime;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.ingredient.test(inv.m_8020_(0));
    }

    public ItemStack m_5874_(Container inv) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TANRecipeSerializers.WATER_PURIFYING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TANRecipeTypes.WATER_PURIFYING.get();
    }

    public int getPurifyTime() {
        return this.purifyTime;
    }

    public static class Serializer
    implements RecipeSerializer<WaterPurifierRecipe> {
        public WaterPurifierRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            StrictNBTIngredient ingredient = StrictNBTIngredient.Serializer.INSTANCE.parse(GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            int purifyTime = GsonHelper.m_13824_((JsonObject)json, (String)"purifytime", (int)200);
            return new WaterPurifierRecipe(recipeId, ingredient, result, purifyTime);
        }

        public WaterPurifierRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            StrictNBTIngredient ingredient = (StrictNBTIngredient)Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            int purifyTime = buffer.readInt();
            return new WaterPurifierRecipe(recipeId, ingredient, result, purifyTime);
        }

        public void toNetwork(FriendlyByteBuf buffer, WaterPurifierRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
            buffer.writeInt(recipe.purifyTime);
        }
    }
}

