/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.registries.RegistryObject;
import toughasnails.api.crafting.TANRecipeSerializers;
import toughasnails.api.crafting.TANRecipeTypes;
import toughasnails.api.potion.TANPotions;
import toughasnails.core.ToughAsNails;
import toughasnails.crafting.WaterPurifierRecipe;

public class ModCrafting {
    public static void init() {
        ModCrafting.registerRecipeSerializers();
    }

    private static void registerRecipeSerializers() {
        TANRecipeSerializers.WATER_PURIFYING = ModCrafting.registerSerializer("water_purifying", () -> new WaterPurifierRecipe.Serializer());
        TANRecipeTypes.WATER_PURIFYING = ModCrafting.registerRecipe("water_purifying", () -> new RecipeType<WaterPurifierRecipe>(){

            public String toString() {
                return "water_purifying";
            }
        });
    }

    public static void registerPotionRecipes() {
        ModCrafting.addBrewingRecipe(Potions.f_43602_, new ItemStack((ItemLike)Items.f_42452_), (Potion)TANPotions.ICE_RESISTANCE.get());
        ModCrafting.addBrewingRecipe((Potion)TANPotions.ICE_RESISTANCE.get(), new ItemStack((ItemLike)Items.f_42451_), (Potion)TANPotions.LONG_ICE_RESISTANCE.get());
        ModCrafting.addPotionTransforms((Potion)TANPotions.ICE_RESISTANCE.get());
        ModCrafting.addPotionTransforms((Potion)TANPotions.LONG_ICE_RESISTANCE.get());
    }

    public static RegistryObject<RecipeSerializer<?>> registerSerializer(String name, Supplier<RecipeSerializer<?>> serializer) {
        return ToughAsNails.RECIPE_SERIALIZER_REGISTER.register(name, serializer);
    }

    public static RegistryObject<RecipeType<?>> registerRecipe(String name, Supplier<RecipeType<?>> type) {
        return ToughAsNails.RECIPE_TYPE_REGISTER.register(name, type);
    }

    private static void addBrewingRecipe(Potion input, ItemStack ingredient, Potion output) {
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42589_), input, ingredient, new ItemStack((ItemLike)Items.f_42589_), output);
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42736_), input, ingredient, new ItemStack((ItemLike)Items.f_42736_), output);
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42739_), input, ingredient, new ItemStack((ItemLike)Items.f_42739_), output);
    }

    private static void addPotionTransforms(Potion potion) {
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42589_), potion, new ItemStack((ItemLike)Items.f_42403_), new ItemStack((ItemLike)Items.f_42736_), potion);
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42739_), potion, new ItemStack((ItemLike)Items.f_42403_), new ItemStack((ItemLike)Items.f_42736_), potion);
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42589_), potion, new ItemStack((ItemLike)Items.f_42735_), new ItemStack((ItemLike)Items.f_42739_), potion);
        ModCrafting.addBrewingRecipe(new ItemStack((ItemLike)Items.f_42736_), potion, new ItemStack((ItemLike)Items.f_42735_), new ItemStack((ItemLike)Items.f_42739_), potion);
    }

    private static void addBrewingRecipe(ItemStack inBottle, Potion inPotion, ItemStack ingredient, ItemStack outBottle, Potion outPotion) {
        BrewingRecipeRegistry.addRecipe((Ingredient)StrictNBTIngredient.of((ItemStack)PotionUtils.m_43549_((ItemStack)inBottle, (Potion)inPotion)), (Ingredient)StrictNBTIngredient.of((ItemStack)ingredient), (ItemStack)PotionUtils.m_43549_((ItemStack)outBottle, (Potion)outPotion));
    }
}

