/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.registries.RegistryObject;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.potion.TANPotions;
import toughasnails.core.ToughAsNails;
import toughasnails.potion.ThirstEffect;

public class ModPotions {
    public static void init() {
        ModPotions.registerEffects();
        ModPotions.registerPotions();
    }

    public static void registerEffects() {
        TANEffects.THIRST = ModPotions.registerEffect("thirst", () -> new ThirstEffect(MobEffectCategory.HARMFUL, 7789388));
        TANEffects.ICE_RESISTANCE = ModPotions.registerEffect("ice_resistance", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 7842303));
        TANEffects.CLIMATE_CLEMENCY = ModPotions.registerEffect("climate_clemency", () -> new MobEffect(MobEffectCategory.NEUTRAL, 0xB6B6B6));
    }

    public static void registerPotions() {
        TANPotions.ICE_RESISTANCE = ModPotions.registerPotion("ice_resistance", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)TANEffects.ICE_RESISTANCE.get(), 1200)}));
        TANPotions.LONG_ICE_RESISTANCE = ModPotions.registerPotion("long_ice_resistance", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)TANEffects.ICE_RESISTANCE.get(), 2400)}));
    }

    public static RegistryObject<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        return ToughAsNails.MOB_EFFECT_REGISTER.register(name, effect);
    }

    public static RegistryObject<Potion> registerPotion(String name, Supplier<Potion> potion) {
        return ToughAsNails.POTION_REGISTER.register(name, potion);
    }
}

