/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.thirst;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import toughasnails.api.capability.TANCapabilities;
import toughasnails.api.item.TANItems;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.api.thirst.WaterType;
import toughasnails.config.ServerConfig;
import toughasnails.config.ThirstConfig;
import toughasnails.init.ModTags;
import toughasnails.network.MessageDrinkInWorld;
import toughasnails.network.MessageUpdateThirst;
import toughasnails.network.PacketHandler;
import toughasnails.thirst.ThirstCapabilityProvider;
import toughasnails.thirst.ThirstData;

public class ThirstHandler {
    private static final int IN_WORLD_DRINK_COOLDOWN = 60;
    private static int inWorldDrinkTimer = 0;

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("toughasnails", "thirst"), (ICapabilityProvider)new ThirstCapabilityProvider(TANCapabilities.THIRST, new ThirstData()));
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().f_19853_.m_5776_()) {
            return;
        }
        ThirstHandler.syncThirst((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!((Boolean)ServerConfig.enableThirst.get()).booleanValue() || event.player.f_19853_.m_5776_()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        IThirst thirst = ThirstHelper.getThirst((Player)player);
        Difficulty difficulty = player.f_19853_.m_46791_();
        double exhaustionThreshold = (Double)ThirstConfig.thirstExhaustionThreshold.get();
        if ((double)thirst.getExhaustion() > exhaustionThreshold) {
            thirst.addExhaustion((float)(-exhaustionThreshold));
            if (thirst.getHydration() > 0.0f) {
                thirst.setHydration(Math.max(thirst.getHydration() - 1.0f, 0.0f));
            } else if (difficulty != Difficulty.PEACEFUL) {
                thirst.setThirst(Math.max(thirst.getThirst() - 1, 0));
            }
        }
        if (thirst.getThirst() <= 0) {
            thirst.addTicks(1);
            if (thirst.getTickTimer() >= 80) {
                if (player.m_21223_() > 10.0f || difficulty == Difficulty.HARD || player.m_21223_() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.m_6469_(DamageSource.f_19313_, 1.0f);
                }
                thirst.setTickTimer(0);
            }
        } else {
            thirst.setTickTimer(0);
        }
        if (difficulty == Difficulty.PEACEFUL && player.f_19853_.m_46469_().m_46207_(GameRules.f_46139_) && thirst.isThirsty() && player.f_19797_ % 10 == 0) {
            thirst.setThirst(thirst.getThirst() + 1);
        }
        if (thirst.getLastThirst() != thirst.getThirst() || thirst.getHydration() == 0.0f != thirst.getLastHydrationZero()) {
            ThirstHandler.syncThirst(player);
            thirst.setLastThirst(thirst.getThirst());
            thirst.setLastHydrationZero(thirst.getHydration() == 0.0f);
        }
    }

    private static void syncThirst(ServerPlayer player) {
        IThirst thirst = ThirstHelper.getThirst((Player)player);
        PacketHandler.HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageUpdateThirst(thirst.getThirst(), thirst.getHydration()));
    }

    @SubscribeEvent
    public void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!((Boolean)ServerConfig.enableThirst.get()).booleanValue() || !(event.getEntity() instanceof Player) || event.getEntity().f_19853_.m_5776_()) {
            return;
        }
        Player player = (Player)event.getEntity();
        ItemStack drink = event.getItem();
        IThirst thirst = ThirstHelper.getThirst(player);
        if (drink.m_204117_(ModTags.Items.DRINKS)) {
            int drink_thirst = ModTags.Items.getThirstRestored(drink);
            float drink_hydration = 0.0f;
            float drink_poison_chance = 0.0f;
            if (drink.m_204117_(ModTags.Items.TEN_HYDRATION_DRINKS)) {
                drink_hydration = 0.1f;
            }
            if (drink.m_204117_(ModTags.Items.TWENTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.2f;
            }
            if (drink.m_204117_(ModTags.Items.THIRTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.3f;
            }
            if (drink.m_204117_(ModTags.Items.FOURTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.4f;
            }
            if (drink.m_204117_(ModTags.Items.FIFTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.5f;
            }
            if (drink.m_204117_(ModTags.Items.SIXTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.6f;
            }
            if (drink.m_204117_(ModTags.Items.SEVENTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.7f;
            }
            if (drink.m_204117_(ModTags.Items.EIGHTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.8f;
            }
            if (drink.m_204117_(ModTags.Items.NINETY_HYDRATION_DRINKS)) {
                drink_hydration = 0.9f;
            }
            if (drink.m_204117_(ModTags.Items.ONE_HUNDRED_HYDRATION_DRINKS)) {
                drink_hydration = 1.0f;
            }
            if (drink.m_204117_(ModTags.Items.TWENTY_FIVE_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 0.25f;
            }
            if (drink.m_204117_(ModTags.Items.FIFTY_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 0.5f;
            }
            if (drink.m_204117_(ModTags.Items.SEVENTY_FIVE_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 0.75f;
            }
            if (drink.m_204117_(ModTags.Items.ONE_HUNDRED_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 1.0f;
            }
            thirst.addThirst(drink_thirst);
            thirst.addHydration(drink_hydration);
            if (player.f_19853_.f_46441_.m_188501_() < drink_poison_chance) {
                player.m_7292_(new MobEffectInstance((MobEffect)TANEffects.THIRST.get(), 600));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteractItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        Level world = player.f_19853_;
        InteractionHand hand = event.getHand();
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item != Items.f_42590_) {
            return;
        }
        BlockHitResult rayTraceResult = Item.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = rayTraceResult.m_82425_();
        if (!world.m_7966_(player, pos) || !world.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            return;
        }
        world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        ResourceKey biome = player.f_19853_.m_204166_(pos).m_203543_().orElse(Biomes.f_48202_);
        ItemStack filledStack = switch (ThirstConfig.getBiomeWaterType((ResourceKey<Biome>)biome)) {
            case WaterType.PURIFIED -> new ItemStack((ItemLike)TANItems.PURIFIED_WATER_BOTTLE.get());
            case WaterType.DIRTY -> new ItemStack((ItemLike)TANItems.DIRTY_WATER_BOTTLE.get());
            default -> PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
        };
        player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
        ItemStack replacementStack = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)filledStack);
        if (stack != replacementStack) {
            player.m_21008_(hand, replacementStack);
            if (replacementStack.m_41619_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)stack, (InteractionHand)hand);
            }
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResultHolder.m_19092_((Object)replacementStack, (boolean)world.m_5776_()).m_19089_());
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (ThirstHandler.canHandDrink() && ThirstHandler.canHandDrinkInWorld(event.getEntity(), event.getHand())) {
            ThirstHandler.tryDrinkWaterInWorld(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (ThirstHandler.canHandDrink() && ThirstHandler.canHandDrinkInWorld(event.getEntity(), event.getHand())) {
            ThirstHandler.tryDrinkWaterInWorld(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (inWorldDrinkTimer > 0) {
            --inWorldDrinkTimer;
        }
    }

    private static boolean canHandDrink() {
        return (Boolean)ServerConfig.enableThirst.get() != false && (Boolean)ServerConfig.enableHandDrinking.get() != false;
    }

    private static boolean canHandDrinkInWorld(Player player, InteractionHand hand) {
        return InteractionHand.MAIN_HAND == hand && player.m_21205_().m_41619_() && player.m_6047_() && ThirstHelper.getThirst(player).getThirst() < 20 && player.f_19853_.m_5776_() && inWorldDrinkTimer <= 0;
    }

    private static void tryDrinkWaterInWorld(Player player) {
        Level world = player.f_19853_;
        BlockHitResult rayTraceResult = Item.m_41435_((Level)player.f_19853_, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = rayTraceResult.m_82425_();
            if (ThirstHelper.canDrink(player, false) && world.m_7966_(player, pos) && world.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
                inWorldDrinkTimer = 60;
                PacketHandler.HANDLER.send(PacketDistributor.SERVER.noArg(), (Object)new MessageDrinkInWorld(pos));
                player.m_5496_(SoundEvents.f_11911_, 0.5f, 1.0f);
                player.m_6674_(InteractionHand.MAIN_HAND);
            }
        }
    }
}

