/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;

public class MessageUpdateTemperature {
    public TemperatureLevel temperatureLevel;
    public int hyperthermiaTicks;

    public MessageUpdateTemperature(TemperatureLevel temperatureLevel, int hyperthermiaTicks) {
        this.temperatureLevel = temperatureLevel;
        this.hyperthermiaTicks = hyperthermiaTicks;
    }

    public static void encode(MessageUpdateTemperature packet, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)packet.temperatureLevel);
        buf.writeInt(packet.hyperthermiaTicks);
    }

    public static MessageUpdateTemperature decode(FriendlyByteBuf buf) {
        return new MessageUpdateTemperature((TemperatureLevel)buf.m_130066_(TemperatureLevel.class), buf.readInt());
    }

    public static class Handler {
        public static void handle(MessageUpdateTemperature packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                if (FMLEnvironment.dist != Dist.CLIENT) {
                    return;
                }
                Handler.updateTemperature(packet.temperatureLevel, packet.hyperthermiaTicks);
            });
            context.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void updateTemperature(TemperatureLevel temperature, int hyperthermiaTicks) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ITemperature data = TemperatureHelper.getTemperatureData((Player)player);
            data.setLevel(temperature);
            data.setHyperthermiaTicks(hyperthermiaTicks);
        }
    }
}

