/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModTags;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.config.TemperatureConfig;
import toughasnails.core.ToughAsNails;

public class ModCompatibility {
    public static void init() {
        if (ModList.get().isLoaded("sereneseasons")) {
            ToughAsNails.LOGGER.info("Serene Seasons detected. Enabling season modifier.");
            TemperatureHelper.registerPositionalTemperatureModifier(ModCompatibility::seasonModifier);
        }
    }

    private static TemperatureLevel seasonModifier(Level level, BlockPos pos, TemperatureLevel current) {
        Holder biome = level.m_204166_(pos);
        if (pos.m_123342_() <= (Integer)TemperatureConfig.environmentalModifierAltitude.get() && !level.m_45527_(pos)) {
            return current;
        }
        if (biome.m_203656_(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            return current;
        }
        if (biome.m_203656_(ModTags.Biomes.TROPICAL_BIOMES)) {
            return current;
        }
        Season season = SeasonHelper.getSeasonState((Level)level).getSeason();
        switch (season) {
            case SUMMER: {
                current = current.increment(1);
                break;
            }
            case WINTER: {
                current = current.decrement(1);
            }
        }
        return current;
    }
}

