/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.client.handler;

import com.mojang.datafixers.util.Either;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import toughasnails.init.ModTags;
import toughasnails.thirst.ThirstOverlayHandler;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TooltipHandler {
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Block block = Block.m_49814_((Item)stack.m_41720_());
        BlockState state = block.m_49966_();
        if (stack.m_204117_(ModTags.Items.HEATING_ITEMS) || stack.m_204117_(ModTags.Items.HEATING_ARMOR) || state.m_204336_(ModTags.Blocks.HEATING_BLOCKS)) {
            event.getToolTip().add(Component.m_237113_((String)"\ud83d\udd25 ").m_7220_((Component)Component.m_237115_((String)"desc.toughasnails.heating")).m_130940_(ChatFormatting.RED));
        }
        if (stack.m_204117_(ModTags.Items.COOLING_ITEMS) || stack.m_204117_(ModTags.Items.COOLING_ARMOR) || state.m_204336_(ModTags.Blocks.COOLING_BLOCKS)) {
            event.getToolTip().add(Component.m_237113_((String)"\u2744 ").m_7220_((Component)Component.m_237115_((String)"desc.toughasnails.cooling")).m_130940_(ChatFormatting.AQUA));
        }
    }

    @SubscribeEvent
    public static void onRenderTooltip(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_204117_(ModTags.Items.DRINKS)) {
            event.getTooltipElements().add(Either.right((Object)new ThirstTooltipComponent(ModTags.Items.getThirstRestored(stack))));
        }
    }

    private static class ThirstTooltipComponent
    implements TooltipComponent {
        private final int amount;

        private ThirstTooltipComponent(int amount) {
            this.amount = amount;
        }

        public int getAmount() {
            return this.amount;
        }
    }

    private static class ThirstClientTooltipComponent
    implements ClientTooltipComponent {
        private final int amount;

        private ThirstClientTooltipComponent(int amount) {
            this.amount = amount;
        }

        public int m_142103_() {
            return 9;
        }

        public int m_142069_(Font font) {
            return this.amount / 2 * 9;
        }

        public void m_183452_(Font font, int x, int y, GuiGraphics gui) {
            gui.m_280168_().m_85836_();
            for (int i = 0; i < Mth.m_14167_((float)((float)this.amount / 2.0f)); ++i) {
                int dropletHalf = i * 2 + 1;
                int startX = x + i * 8 - 1;
                int startY = y;
                gui.m_280163_(ThirstOverlayHandler.OVERLAY, startX, startY, 9.0f, 32.0f, 9, 9, 256, 256);
                if (this.amount > dropletHalf) {
                    gui.m_280163_(ThirstOverlayHandler.OVERLAY, startX, startY, 36.0f, 32.0f, 9, 9, 256, 256);
                    continue;
                }
                if (this.amount != dropletHalf) continue;
                gui.m_280163_(ThirstOverlayHandler.OVERLAY, startX, startY, 9.0f, 41.0f, 9, 9, 256, 256);
            }
            gui.m_280168_().m_85849_();
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    private static class ClientTooltipRegisterHandler {
        private ClientTooltipRegisterHandler() {
        }

        @SubscribeEvent
        public static void onRegisterFactories(RegisterClientTooltipComponentFactoriesEvent event) {
            event.register(ThirstTooltipComponent.class, component -> new ThirstClientTooltipComponent(component.getAmount()));
        }
    }
}

