/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.container;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import toughasnails.api.crafting.TANRecipeTypes;
import toughasnails.api.inventory.container.TANContainerTypes;
import toughasnails.block.entity.WaterPurifierBlockEntity;
import toughasnails.container.WaterPurifierFilterSlot;
import toughasnails.container.WaterPurifierResultSlot;

public class WaterPurifierContainer
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData data;
    private final Level level;

    public WaterPurifierContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(4));
    }

    public WaterPurifierContainer(int id, Inventory playerInventory, Container container, ContainerData data) {
        super((MenuType)TANContainerTypes.WATER_PURIFIER.get(), id);
        this.container = container;
        this.data = data;
        this.level = playerInventory.f_35978_.m_9236_();
        this.m_38897_(new Slot(container, 0, 56, 17));
        this.m_38897_(new WaterPurifierFilterSlot(this, container, 1, 56, 53));
        this.m_38897_(new WaterPurifierResultSlot(container, 2, 116, 35));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            this.m_38897_(new Slot((Container)playerInventory, slot, 8 + slot * 18, 142));
        }
        this.m_38884_(data);
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack prevItem = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            prevItem = slotItem.m_41777_();
            if (index == 2) {
                if (!this.m_38903_(slotItem, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotItem, prevItem);
            } else if (index != 1 && index != 0 ? (this.canPurify(slotItem) ? !this.m_38903_(slotItem, 0, 1, false) : (this.isFilter(slotItem) ? !this.m_38903_(slotItem, 1, 2, false) : (index >= 3 && index < 30 ? !this.m_38903_(slotItem, 30, 39, false) : index >= 30 && index < 39 && !this.m_38903_(slotItem, 3, 30, false)))) : !this.m_38903_(slotItem, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotItem.m_41613_() == prevItem.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotItem);
        }
        return prevItem;
    }

    protected boolean canPurify(ItemStack stack) {
        return this.level.m_7465_().m_44015_((RecipeType)TANRecipeTypes.WATER_PURIFYING.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.level).isPresent();
    }

    protected boolean isFilter(ItemStack stack) {
        return WaterPurifierBlockEntity.isFilter(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getPurifyProgress() {
        int progress = this.data.m_6413_(2);
        int totalTime = this.data.m_6413_(3);
        return totalTime != 0 && progress != 0 ? progress * 24 / totalTime : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFilterProgress() {
        int filterDuration = this.data.m_6413_(1);
        if (filterDuration == 0) {
            filterDuration = 200;
        }
        return this.data.m_6413_(0) * 13 / filterDuration;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFiltering() {
        return this.data.m_6413_(0) > 0;
    }
}

