/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import toughasnails.api.crafting.TANRecipeSerializers;
import toughasnails.api.crafting.TANRecipeTypes;

public class WaterPurifierRecipe
implements Recipe<Container> {
    protected final ItemStack input;
    protected final ItemStack result;
    protected final int purifyTime;

    public WaterPurifierRecipe(ItemStack input, ItemStack result, int purifyTime) {
        this.input = input;
        this.result = result;
        this.purifyTime = purifyTime;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (this.input == null) {
            return false;
        }
        ItemStack containerInput = inv.m_8020_(0);
        return this.input.m_41720_() == containerInput.m_41720_() && this.input.m_41773_() == containerInput.m_41773_() && this.input.areShareTagsEqual(containerInput);
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TANRecipeSerializers.WATER_PURIFYING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TANRecipeTypes.WATER_PURIFYING.get();
    }

    public int getPurifyTime() {
        return this.purifyTime;
    }

    public static class Serializer
    implements RecipeSerializer<WaterPurifierRecipe> {
        private static final Codec<WaterPurifierRecipe> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.f_41582_.fieldOf("input").forGetter(p_296920_ -> p_296920_.input), (App)ItemStack.f_41582_.fieldOf("result").forGetter(p_296923_ -> p_296923_.result), (App)Codec.INT.fieldOf("purifytime").orElse((Object)200).forGetter(p_296919_ -> p_296919_.purifyTime)).apply((Applicative)builder, WaterPurifierRecipe::new));

        public WaterPurifierRecipe fromNetwork(FriendlyByteBuf buffer) {
            ItemStack input = buffer.m_130267_();
            ItemStack result = buffer.m_130267_();
            int purifyTime = buffer.readInt();
            return new WaterPurifierRecipe(input, result, purifyTime);
        }

        public Codec<WaterPurifierRecipe> m_292673_() {
            return CODEC;
        }

        public void toNetwork(FriendlyByteBuf buffer, WaterPurifierRecipe recipe) {
            buffer.m_130055_(recipe.input);
            buffer.m_130055_(recipe.result);
            buffer.writeInt(recipe.purifyTime);
        }
    }
}

