/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.datagen.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.Util;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import toughasnails.api.crafting.TANRecipeSerializers;

public class WaterPurifierRecipeBuilder {
    private final ItemStack input;
    private final ItemStack result;
    private final int purifyTime;

    private WaterPurifierRecipeBuilder(ItemStack input, ItemStack result, int purifyTime) {
        this.input = input;
        this.result = result;
        this.purifyTime = purifyTime;
    }

    public static WaterPurifierRecipeBuilder waterPurifier(ItemStack input, ItemStack result, int purifyTime) {
        return new WaterPurifierRecipeBuilder(input, result, purifyTime);
    }

    public void save(RecipeOutput output, String name) {
        this.save(output, new ResourceLocation(name));
    }

    public void save(RecipeOutput output, ResourceLocation location) {
        output.m_292927_((FinishedRecipe)new Result(location, (RecipeSerializer)TANRecipeSerializers.WATER_PURIFYING.get(), this.input, this.result, this.purifyTime));
    }

    public static final class Result
    extends Record
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final RecipeSerializer<?> type;
        private final ItemStack input;
        private final ItemStack result;
        private final int purifyTime;

        public Result(ResourceLocation id, RecipeSerializer<?> type, ItemStack input, ItemStack result, int purifyTime) {
            this.id = id;
            this.type = type;
            this.input = input;
            this.result = result;
            this.purifyTime = purifyTime;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", (JsonElement)Util.m_260975_((DataResult)ItemStack.f_41582_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.input), IllegalStateException::new));
            json.add("result", (JsonElement)Util.m_260975_((DataResult)ItemStack.f_41582_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.result), IllegalStateException::new));
            json.addProperty("purifytime", (Number)this.purifyTime);
        }

        public ResourceLocation m_126168_() {
            return this.id;
        }

        public RecipeSerializer<?> m_126169_() {
            return this.type;
        }

        public AdvancementHolder m_126373_() {
            return null;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Result.class, "id;type;input;result;purifyTime", "id", "type", "input", "result", "purifyTime"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Result.class, "id;type;input;result;purifyTime", "id", "type", "input", "result", "purifyTime"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Result.class, "id;type;input;result;purifyTime", "id", "type", "input", "result", "purifyTime"}, this, o);
        }

        public ItemStack input() {
            return this.input;
        }

        public ItemStack result() {
            return this.result;
        }

        public int purifyTime() {
            return this.purifyTime;
        }
    }
}

