/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.network;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.network.CustomPayloadEvent;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.config.ThirstConfig;

public class MessageDrinkInWorld {
    public BlockPos pos;

    public MessageDrinkInWorld(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(MessageDrinkInWorld packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
    }

    public static MessageDrinkInWorld decode(FriendlyByteBuf buf) {
        return new MessageDrinkInWorld(buf.m_130135_());
    }

    public static class Handler {
        public static void handle(MessageDrinkInWorld packet, CustomPayloadEvent.Context context) {
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                Level level = player.m_9236_();
                IThirst thirst = ThirstHelper.getThirst((Player)player);
                if (level.m_7966_((Player)player, packet.pos) && level.m_6425_(packet.pos).m_205070_(FluidTags.f_13131_)) {
                    thirst.addThirst((Integer)ThirstConfig.handDrinkingThirst.get());
                    thirst.addHydration(((Double)ThirstConfig.handDrinkingHydration.get()).floatValue());
                    Holder biome = level.m_204166_(packet.pos);
                    if (level.f_46441_.m_188501_() < ThirstConfig.getBiomeWaterType((Holder<Biome>)biome).getPoisonChance()) {
                        player.m_7292_(new MobEffectInstance((MobEffect)TANEffects.THIRST.get(), 600));
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

