/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.config.ServerConfig;
import toughasnails.temperature.TemperatureData;

public class TemperatureCapabilityProvider
implements INBTSerializable<CompoundTag>,
ICapabilityProvider {
    private Capability<ITemperature> capability;
    private ITemperature instance;

    public TemperatureCapabilityProvider(Capability capability, ITemperature instance) {
        this.capability = capability;
        this.instance = instance;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == this.capability ? LazyOptional.of(() -> this.instance).cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        if (((Boolean)ServerConfig.enableTemperature.get()).booleanValue()) {
            compound.m_128405_("temperatureLevel", this.instance.getLevel().ordinal());
            compound.m_128405_("targetTemperatureLevel", this.instance.getTargetLevel().ordinal());
            compound.m_128405_("changeDelayTicks", this.instance.getChangeDelayTicks());
            compound.m_128405_("hyperthermiaTicks", this.instance.getHyperthermiaTicks());
            compound.m_128405_("extremityDelayTicks", this.instance.getExtremityDelayTicks());
            compound.m_128405_("dryTicks", this.instance.getDryTicks());
        } else {
            compound.m_128405_("temperatureLevel", TemperatureData.DEFAULT_LEVEL.ordinal());
            compound.m_128405_("targetTemperatureLevel", TemperatureData.DEFAULT_LEVEL.ordinal());
            compound.m_128405_("changeDelayTicks", 0);
            compound.m_128405_("hyperthermiaTicks", 0);
            compound.m_128405_("extremityDelayTicks", 0);
            compound.m_128405_("dryTicks", 0);
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_("temperatureLevel", 99)) {
            if (((Boolean)ServerConfig.enableTemperature.get()).booleanValue()) {
                this.instance.setLevel(TemperatureLevel.values()[nbt.m_128451_("temperatureLevel")]);
                this.instance.setTargetLevel(TemperatureLevel.values()[nbt.m_128451_("targetTemperatureLevel")]);
                this.instance.setChangeDelayTicks(nbt.m_128451_("changeDelayTicks"));
                this.instance.setHyperthermiaTicks(nbt.m_128451_("hyperthermiaTicks"));
                this.instance.setExtremityDelayTicks(nbt.m_128451_("extremityDelayTicks"));
            } else {
                this.instance.setLevel(TemperatureData.DEFAULT_LEVEL);
                this.instance.setTargetLevel(TemperatureData.DEFAULT_LEVEL);
                this.instance.setChangeDelayTicks(0);
                this.instance.setHyperthermiaTicks(0);
                this.instance.setExtremityDelayTicks(0);
                this.instance.setDryTicks(0);
            }
        }
    }
}

