/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.unenchanted.common.containers;

import com.favouriteless.unenchanted.core.init.UnenchantedBlocks;
import com.favouriteless.unenchanted.core.init.UnenchantedContainers;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;

public class UnenchantingContainer
extends Container {
    private final IInventory inputSlots = new Inventory(2){

        public void func_70296_d() {
            super.func_70296_d();
            UnenchantingContainer.this.func_75130_a((IInventory)this);
        }
    };
    private final IInventory resultSlots = new CraftResultInventory();
    private final IWorldPosCallable access;
    private final IntReferenceHolder cost = IntReferenceHolder.func_221492_a();

    public UnenchantingContainer(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory);
    }

    public UnenchantingContainer(int windowId, PlayerInventory playerInventory) {
        this(windowId, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public UnenchantingContainer(int windowId, PlayerInventory playerInventory, IWorldPosCallable access) {
        super((ContainerType)UnenchantedContainers.UNENCHANTING_TABLE.get(), windowId);
        this.access = access;
        this.func_75146_a(new SlotEnchantInput(this.inputSlots, 0, 27, 47));
        this.func_75146_a(new SlotBookInput(this.inputSlots, 1, 76, 47));
        this.func_75146_a(new SlotOutput(this.resultSlots, 0, 134, 47));
        this.AddInventorySlots(playerInventory);
        this.func_216958_a(this.cost);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return UnenchantingContainer.func_216963_a((IWorldPosCallable)this.access, (PlayerEntity)player, (Block)((Block)UnenchantedBlocks.UNENCHANTING_TABLE.get()));
    }

    public void func_75134_a(PlayerEntity playerEntity) {
        super.func_75134_a(playerEntity);
        this.access.func_221486_a((p_217004_2_, p_217004_3_) -> this.func_193327_a(playerEntity, playerEntity.field_70170_p, this.inputSlots));
    }

    public void func_75130_a(IInventory inventory) {
        super.func_75130_a(inventory);
        if (inventory != this.resultSlots) {
            this.createResult();
        }
    }

    protected void AddInventorySlots(PlayerInventory playerInventory) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + 18 * x, 142));
        }
    }

    protected boolean mayPickup(PlayerEntity playerEntity, boolean hasItem) {
        return (playerEntity.field_71075_bZ.field_75098_d || playerEntity.field_71068_ca >= this.cost.func_221495_b()) && this.cost.func_221495_b() > 0;
    }

    protected ItemStack onTake(PlayerEntity playerEntity, ItemStack itemStack) {
        if (!playerEntity.field_71075_bZ.field_75098_d) {
            playerEntity.func_82242_a(-this.cost.func_221495_b());
        }
        this.inputSlots.func_70298_a(0, 1);
        this.inputSlots.func_70298_a(1, 1);
        this.cost.func_221494_a(0);
        this.access.func_221486_a((world, pos) -> world.func_217379_c(1030, pos, 0));
        return itemStack;
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        ItemStack lvt_3_1_ = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotItem = slot.func_75211_c();
            lvt_3_1_ = slotItem.func_77946_l();
            if (index <= 1) {
                if (!this.func_75135_a(slotItem, 3, 39, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 2) {
                if (!this.func_75135_a(slotItem, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotItem, lvt_3_1_);
            } else if (index < 39 && (((Slot)this.field_75151_b.get(0)).func_75214_a(slotItem) ? !this.func_75135_a(slotItem, 0, 1, false) : ((Slot)this.field_75151_b.get(1)).func_75214_a(slotItem) && !this.func_75135_a(slotItem, 1, 2, false))) {
                return ItemStack.field_190927_a;
            }
            if (slotItem.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotItem.func_190916_E() == lvt_3_1_.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerEntity, slotItem);
        }
        return lvt_3_1_;
    }

    public void createResult() {
        ItemStack inputItem = this.inputSlots.func_70301_a(0);
        ItemStack inputBook = this.inputSlots.func_70301_a(1);
        if (inputItem.func_190926_b() || inputBook.func_190926_b()) {
            this.resultSlots.func_70299_a(0, ItemStack.field_190927_a);
            this.cost.func_221494_a(0);
            return;
        }
        ItemStack result = new ItemStack((IItemProvider)Items.field_151134_bR);
        Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)inputItem);
        EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)inputItem), (ItemStack)result);
        int levelCost = 0;
        for (Enchantment enchantment : enchantmentMap.keySet()) {
            levelCost += 4 + (Integer)enchantmentMap.get(enchantment);
        }
        this.resultSlots.func_70299_a(0, result);
        this.cost.func_221494_a(levelCost);
    }

    public int getCost() {
        return this.cost.func_221495_b();
    }

    public class SlotOutput
    extends Slot {
        public SlotOutput(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack itemStack) {
            return false;
        }

        public boolean func_82869_a(PlayerEntity playerEntity) {
            return UnenchantingContainer.this.mayPickup(playerEntity, this.func_75216_d());
        }

        public ItemStack func_190901_a(PlayerEntity playerEntity, ItemStack itemStack) {
            return UnenchantingContainer.this.onTake(playerEntity, itemStack);
        }
    }

    public class SlotBookInput
    extends Slot {
        public SlotBookInput(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77973_b() == Items.field_151122_aG && !stack.func_77948_v();
        }
    }

    public class SlotEnchantInput
    extends Slot {
        public SlotEnchantInput(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.func_77973_b() != Items.field_151122_aG && stack.func_77948_v();
        }
    }
}

