/*
 * Decompiled with CFR 0.152.
 */
package fi.crare1.usefultools.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public interface IItemBaseTool {
    default public boolean isDirtBlock(Block block) {
        return block.equals(Blocks.field_150346_d) || block.equals(Blocks.field_196658_i) || block.equals(Blocks.field_196660_k) || block.equals(Blocks.field_196661_l) || block.equals(Blocks.field_185774_da) || block.equals(Blocks.field_150458_ak) || block.equals(Blocks.field_150391_bh);
    }

    default public boolean isTallGrassBlock(Block block) {
        return block.equals(Blocks.field_150349_c) || block.equals(Blocks.field_196804_gh) || block.equals(Blocks.field_196554_aH) || block.equals(Blocks.field_196805_gi);
    }

    default public boolean isAirOrBushBlock(BlockPos pos, World world) {
        return world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150350_a) || BushBlock.class.isAssignableFrom(world.func_180495_p(pos).func_177230_c().getClass());
    }

    default public boolean isAirBlock(BlockPos pos, World world) {
        return world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150350_a);
    }

    default public List<BlockPos> getAdjacentBlockPositions(BlockPos pos) {
        ArrayList<BlockPos> adjacentBlocks = new ArrayList<BlockPos>();
        adjacentBlocks.add(pos.func_177978_c());
        adjacentBlocks.add(pos.func_177974_f());
        adjacentBlocks.add(pos.func_177976_e());
        adjacentBlocks.add(pos.func_177968_d());
        adjacentBlocks.add(pos.func_177978_c().func_177974_f());
        adjacentBlocks.add(pos.func_177978_c().func_177976_e());
        adjacentBlocks.add(pos.func_177968_d().func_177974_f());
        adjacentBlocks.add(pos.func_177968_d().func_177976_e());
        return adjacentBlocks;
    }

    default public ActionResult<ItemStack> replaceDirtBlockWith(BlockPos blockPos, Block replacerBlock, SoundEvent sound, PlayerEntity playerIn, World worldIn) {
        Block block = worldIn.func_180495_p(blockPos).func_177230_c();
        if (block.equals(Blocks.field_150350_a)) {
            blockPos = blockPos.func_177977_b();
        }
        if (this.isDirtBlock(block) && this.isAirBlock(blockPos.func_177984_a(), worldIn) && playerIn.func_184614_ca().func_77952_i() <= playerIn.func_184614_ca().func_77958_k()) {
            if (block.equals(replacerBlock)) {
                return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184614_ca());
            }
            worldIn.func_175656_a(blockPos, replacerBlock.func_176223_P());
            worldIn.func_184133_a(playerIn, blockPos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            playerIn.func_184614_ca().func_222118_a(1, (LivingEntity)playerIn, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
            return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184614_ca());
        }
        return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184614_ca());
    }

    default public ActionResult<ItemStack> replaceDirtBlockInAreaWith(BlockPos blockPos, Block replacerBlock, SoundEvent sound, PlayerEntity playerIn, World worldIn) {
        ArrayList<BlockPos> blockPosses = new ArrayList<BlockPos>();
        blockPosses.add(blockPos);
        blockPosses.addAll(this.getAdjacentBlockPositions(blockPos));
        boolean usedItem = false;
        for (BlockPos pos : blockPosses) {
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            if (block.equals(Blocks.field_150350_a)) {
                pos = pos.func_177977_b();
            }
            if (!this.isDirtBlock(block) || !this.isAirBlock(pos.func_177984_a(), worldIn) || block.equals(replacerBlock) || playerIn.func_184614_ca().func_77952_i() > playerIn.func_184614_ca().func_77958_k()) continue;
            usedItem = true;
            worldIn.func_184133_a(playerIn, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_175656_a(pos, replacerBlock.func_176223_P());
            playerIn.func_184614_ca().func_222118_a(1, (LivingEntity)playerIn, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        if (usedItem) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184614_ca());
        }
        return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184614_ca());
    }

    default public BlockPos getBlockPosPlayerIsStandingOn(LivingEntity playerIn, World worldIn) {
        BlockPos pos = playerIn.func_233580_cy_();
        if (this.isAirOrBushBlock(pos, worldIn)) {
            pos = pos.func_177977_b();
        }
        return pos;
    }

    default public boolean isGrowableItem(Item item) {
        if (!BlockNamedItem.class.isAssignableFrom(item.getClass())) {
            return false;
        }
        BlockNamedItem blItem = (BlockNamedItem)item;
        return IGrowable.class.isAssignableFrom(blItem.func_179223_d().getClass());
    }

    default public boolean isCropsBlock(Block block) {
        return CropsBlock.class.isAssignableFrom(block.getClass());
    }

    default public Direction getBlockFaceHitted(Vector3d hit, BlockPos pos) {
        if (hit.field_72448_b % 1.0 == 0.0) {
            if (hit.field_72448_b == (double)pos.func_177956_o()) {
                return Direction.DOWN;
            }
            if (hit.field_72448_b == (double)(pos.func_177956_o() + 1)) {
                return Direction.UP;
            }
        } else {
            if (hit.field_72450_a % 1.0 == 0.0) {
                if (hit.field_72450_a > (double)pos.func_177958_n()) {
                    return Direction.EAST;
                }
                return Direction.WEST;
            }
            if (hit.field_72449_c % 1.0 == 0.0) {
                if (hit.field_72449_c > (double)pos.func_177952_p()) {
                    return Direction.SOUTH;
                }
                return Direction.NORTH;
            }
        }
        return null;
    }

    default public List<BlockPos> getBlockPositionsAroundBlockFace(Direction face, BlockPos pos, int radius) {
        ArrayList<BlockPos> blockPosses = new ArrayList<BlockPos>();
        if (face == Direction.UP || face == Direction.DOWN) {
            blockPosses.add(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()));
            blockPosses.add(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()));
            blockPosses.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1));
            blockPosses.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1));
            blockPosses.add(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p() - 1));
            blockPosses.add(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p() + 1));
            blockPosses.add(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p() - 1));
            blockPosses.add(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p() + 1));
        } else if (face == Direction.NORTH || face == Direction.SOUTH) {
            blockPosses.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
            blockPosses.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
            blockPosses.add(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()));
            blockPosses.add(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()));
            blockPosses.add(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o() + 1, pos.func_177952_p()));
            blockPosses.add(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p()));
            blockPosses.add(new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p()));
            blockPosses.add(new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o() - 1, pos.func_177952_p()));
        } else if (face == Direction.EAST || face == Direction.WEST) {
            blockPosses.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
            blockPosses.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
            blockPosses.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1));
            blockPosses.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1));
            blockPosses.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p() - 1));
            blockPosses.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p() + 1));
            blockPosses.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p() - 1));
            blockPosses.add(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p() + 1));
        }
        return blockPosses;
    }
}

