/*
 * Decompiled with CFR 0.152.
 */
package fi.crare1.usefultools.item;

import fi.crare1.usefultools.item.ModTierItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ItemChoppingTool
extends AxeItem {
    public ItemChoppingTool(ModTierItem tier, Item.Properties builder) {
        super((IItemTier)tier, tier.func_200929_c(), tier.getAttackSpeed(), builder);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.usefultools.chopping_tool.tooltip", (Object[])new Object[0])));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.usefultools.tooltip.hold_shift_to_show_more", (Object[])new Object[0])));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return this.chopConnectedBlocks(context);
    }

    private ActionResultType chopConnectedBlocks(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            return ActionResultType.PASS;
        }
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        PlayerEntity playerentity = context.func_195999_j();
        if (this.IsWoodLog(blockstate) && playerentity != null) {
            ItemStack stack = context.func_195996_i().getStack();
            ArrayList<BlockPos> connectedBlocks = this.getConnectedBlocks(world, blockpos, blockstate.func_177230_c(), stack.func_77958_k() - stack.func_77952_i());
            world.func_184133_a(playerentity, playerentity.func_233580_cy_(), SoundEvents.field_187724_dU, SoundCategory.PLAYERS, 1.0f, 1.0f);
            playerentity.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.usefultools.chopping_tool.analyzeinfo", (Object[])new Object[]{connectedBlocks.size() + 1})), true);
        }
        return ActionResultType.PASS;
    }

    private boolean IsWoodLog(BlockState blockstate) {
        return RotatedPillarBlock.class.isAssignableFrom(blockstate.func_177230_c().getClass()) && this.IsWoodBlock(blockstate);
    }

    private boolean IsWoodBlock(BlockState blockstate) {
        return blockstate.func_185904_a().equals(Material.field_151575_d) || blockstate.func_185904_a().equals(Material.field_237214_y_);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(1, entityLiving, consumer -> consumer.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        if (RotatedPillarBlock.class.isAssignableFrom(state.func_177230_c().getClass())) {
            int i;
            ArrayList<BlockPos> connectedBlocks = this.getConnectedBlocks(worldIn, pos, state.func_177230_c(), stack.func_77958_k() - stack.func_77952_i());
            for (i = 0; i < connectedBlocks.size() && stack.func_77952_i() < stack.func_77958_k(); ++i) {
                worldIn.func_175656_a(connectedBlocks.get(i), Blocks.field_150350_a.func_176223_P());
                stack.func_222118_a(1, entityLiving, consumer -> consumer.func_213361_c(EquipmentSlotType.MAINHAND));
            }
            if (i > 0) {
                PlayerEntity player = (PlayerEntity)entityLiving;
                player.func_71019_a(new ItemStack((IItemProvider)state.func_177230_c(), i), false);
            }
        }
        return true;
    }

    private ArrayList<BlockPos> getConnectedBlocks(World worldIn, BlockPos pos, Block block, int maxBlocksToBreak) {
        return new ArrayList<BlockPos>(this.getAdjacentBlocks(worldIn, pos, block, new ArrayList<BlockPos>(), maxBlocksToBreak));
    }

    private ArrayList<BlockPos> getAdjacentBlocks(World worldIn, BlockPos pos, Block block, ArrayList<BlockPos> similarBlocks, int maxBlocksToBreak) {
        ArrayList<BlockPos> neighbours = new ArrayList<BlockPos>();
        neighbours.add(pos.func_177978_c());
        neighbours.add(pos.func_177974_f());
        neighbours.add(pos.func_177976_e());
        neighbours.add(pos.func_177968_d());
        neighbours.add(pos.func_177978_c().func_177974_f());
        neighbours.add(pos.func_177978_c().func_177976_e());
        neighbours.add(pos.func_177968_d().func_177974_f());
        neighbours.add(pos.func_177968_d().func_177976_e());
        neighbours.add(pos.func_177984_a());
        neighbours.add(pos.func_177984_a().func_177978_c());
        neighbours.add(pos.func_177984_a().func_177974_f());
        neighbours.add(pos.func_177984_a().func_177976_e());
        neighbours.add(pos.func_177984_a().func_177968_d());
        neighbours.add(pos.func_177984_a().func_177978_c().func_177974_f());
        neighbours.add(pos.func_177984_a().func_177978_c().func_177976_e());
        neighbours.add(pos.func_177984_a().func_177968_d().func_177974_f());
        neighbours.add(pos.func_177984_a().func_177968_d().func_177976_e());
        for (BlockPos neighbour : neighbours) {
            if (!worldIn.func_180495_p(neighbour).func_177230_c().equals(block) || similarBlocks.contains(neighbour)) continue;
            similarBlocks.add(neighbour);
            if (similarBlocks.size() > maxBlocksToBreak) break;
            similarBlocks = this.getAdjacentBlocks(worldIn, neighbour, block, similarBlocks, maxBlocksToBreak);
        }
        return similarBlocks;
    }
}

