/*
 * Decompiled with CFR 0.152.
 */
package fi.crare1.usefultools.item;

import fi.crare1.usefultools.item.IItemBaseTool;
import fi.crare1.usefultools.item.ModTierItem;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class ItemMultiBlockPickaxe
extends PickaxeItem
implements IItemBaseTool {
    private final int radius;
    private final String tooltip;

    public ItemMultiBlockPickaxe(int radius, ModTierItem tier, Item.Properties builder, String tooltip) {
        super((IItemTier)tier, (int)tier.func_200929_c(), tier.getAttackSpeed(), builder);
        this.radius = radius;
        this.tooltip = tooltip;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)this.tooltip, (Object[])new Object[0])));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.usefultools.tooltip.hold_shift_to_show_more", (Object[])new Object[0])));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        this.addParticlesToBlockFaces(stack, entity);
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K) {
            this.breakBlocksAroundBlockFace(itemstack, pos, player);
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    private void breakBlocksAroundBlockFace(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        ServerPlayerEntity serverPlayerEntity;
        World worldIn = player.field_70170_p;
        BlockRayTraceResult raytraceresult = ItemMultiBlockPickaxe.func_219968_a((World)worldIn, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult blockRayTraceResult = raytraceresult;
        BlockPos hitpos = blockRayTraceResult.func_216350_a();
        if (this.isSamePosition(pos, hitpos) && blockRayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK && this.canHarvestBlock(itemstack, worldIn.func_180495_p(pos)) && (serverPlayerEntity = worldIn.func_73046_m().func_184103_al().func_177451_a(player.func_110124_au())) != null) {
            Vector3d hit = blockRayTraceResult.func_216347_e();
            Direction face = this.getBlockFaceHitted(hit, pos);
            List blockPosses = this.getBlockPositionsAroundBlockFace(face, pos, this.radius);
            for (BlockPos blockPos : blockPosses) {
                BlockState blockState = worldIn.func_180495_p(blockPos);
                if (!this.canHarvestBlock(itemstack, blockState) || blockState.func_177230_c().equals(Blocks.field_150357_h)) continue;
                serverPlayerEntity.field_71134_c.func_180237_b(blockPos);
            }
        }
    }

    private void addParticlesToBlockFaces(ItemStack stack, LivingEntity entity) {
        World world = entity.field_70170_p;
        PlayerEntity player = (PlayerEntity)entity;
        BlockRayTraceResult raytraceresult = ItemMultiBlockPickaxe.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        Vector3d hit = raytraceresult.func_216347_e();
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult blockRayTraceResult = raytraceresult;
        BlockPos blockpos = blockRayTraceResult.func_216350_a();
        if (this.canHarvestBlock(stack, world.func_180495_p(blockpos))) {
            Direction face = this.getBlockFaceHitted(hit, blockpos);
            List blockPosses = this.getBlockPositionsAroundBlockFace(face, blockpos, this.radius);
            for (BlockPos blockPos : blockPosses) {
                BlockState blockState = world.func_180495_p(blockPos);
                if (!this.canHarvestBlock(stack, blockState) || blockState.func_177230_c().equals(Blocks.field_150357_h)) continue;
                Vector3d particlePos = new Vector3d((double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f));
                double xSpeed = 0.0;
                double ySpeed = 0.0;
                double zSpeed = 0.0;
                if (face == Direction.DOWN) {
                    particlePos = particlePos.func_72441_c(0.0, (double)-0.6f, 0.0);
                    ySpeed = -0.1;
                } else if (face == Direction.UP) {
                    particlePos = particlePos.func_72441_c(0.0, (double)0.6f, 0.0);
                    ySpeed = 0.1;
                } else if (face == Direction.NORTH) {
                    particlePos = particlePos.func_72441_c(0.0, 0.0, (double)-0.6f);
                    zSpeed = -0.1;
                } else if (face == Direction.SOUTH) {
                    particlePos = particlePos.func_72441_c(0.0, 0.0, (double)0.6f);
                    zSpeed = 0.1;
                } else if (face == Direction.WEST) {
                    particlePos = particlePos.func_72441_c((double)-0.6f, 0.0, 0.0);
                    xSpeed = -0.1;
                } else if (face == Direction.EAST) {
                    particlePos = particlePos.func_72441_c((double)0.6f, 0.0, 0.0);
                    xSpeed = 0.1;
                }
                world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, world.func_180495_p(new BlockPos((Vector3i)blockPos))), particlePos.func_82615_a(), particlePos.func_82617_b(), particlePos.func_82616_c(), xSpeed, ySpeed, zSpeed);
            }
        }
    }

    private boolean isSamePosition(BlockPos a, BlockPos b) {
        return a.func_177958_n() == b.func_177958_n() && a.func_177956_o() == b.func_177956_o() && a.func_177952_p() == b.func_177952_p();
    }
}

