/*
 * Decompiled with CFR 0.152.
 */
package com.jukepoks1.usefultools.worldgeneration;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jukepoks1.usefultools.UsefulToolsMod;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class ModWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    private void generateOverworld(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateBlocks(Blocks.field_150368_y.func_176223_P(), world, random, chunkX * 16, chunkZ * 16, 64, 128, 1);
    }

    private void generateBlocks(IBlockState block, World world, Random random, int x, int z, int minY, int maxY, int chances) {
        int deltaY = maxY - minY;
        for (int i = 0; i < chances; ++i) {
            int depth;
            int height;
            int width;
            BlockPos pos = new BlockPos(x + random.nextInt(16), minY + random.nextInt(deltaY), z + random.nextInt(16));
            BlockPos topPos = world.func_175672_r(pos);
            if (!this.checkAreaForStructure(world, topPos, width = 9, height = 7, depth = 9, block) || !this.getChanceToGenerate(1, 100)) continue;
            Chunk chunk = world.func_175726_f(topPos);
            UsefulToolsMod.logger.info("chunk x=" + chunk.field_76635_g + " z=" + chunk.field_76647_h);
            UsefulToolsMod.logger.info("topPos x=" + topPos.func_177958_n() + ", y=" + topPos.func_177956_o() + ", z=" + topPos.func_177952_p());
            ChunkPos c_pos = chunk.func_76632_l();
            BlockPos new_pos = new BlockPos(c_pos.func_180334_c(), topPos.func_177956_o(), c_pos.func_180333_d());
            UsefulToolsMod.logger.info("chunkBlockStartPos x=" + c_pos.func_180334_c() + " z=" + c_pos.func_180333_d());
            String templatename = "room_chunk";
            Gson gson = new Gson();
            ResourceLocation location = new ResourceLocation("usefultoolsmod:templates/" + templatename + ".json");
            InputStream in = null;
            try {
                in = Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b();
            }
            catch (IOException e) {
                e.printStackTrace();
                UsefulToolsMod.logger.info("Error loading resource!");
            }
            if (in != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
                JsonObject json = je.getAsJsonObject();
                UsefulToolsMod.logger.info("Loaded resource!");
                this.generateStructureFromJsonTemplate(json, world, new_pos);
            }
            UsefulToolsMod.logger.info("generated structure at x=" + topPos.func_177958_n() + ", y=" + topPos.func_177956_o() + ", z=" + topPos.func_177952_p());
        }
    }

    private void generateStructureFromJsonTemplate(JsonObject json, World world, BlockPos pos) {
        JsonObject json_o = json.getAsJsonObject();
        JsonArray pattern = (JsonArray)json_o.get("pattern");
        for (int y = 0; y < pattern.size(); ++y) {
            JsonArray plane = pattern.get(y).getAsJsonArray();
            for (int z = 0; z < plane.size(); ++z) {
                for (int x = 0; x < plane.get(z).getAsString().length(); ++x) {
                    char blockType = plane.get(z).getAsString().charAt(x);
                    BlockPos s_pos = new BlockPos(x + pos.func_177958_n(), y + pos.func_177956_o(), z + pos.func_177952_p());
                    IBlockState block = null;
                    switch (blockType) {
                        case 'X': {
                            block = Blocks.field_150385_bj.func_176223_P();
                            break;
                        }
                        case '#': {
                            block = Blocks.field_150478_aa.func_176223_P();
                            break;
                        }
                        case 'Z': {
                            block = Blocks.field_189879_dh.func_176223_P();
                            break;
                        }
                        case 'Y': {
                            block = Blocks.field_150364_r.func_176223_P();
                            break;
                        }
                        case 'S': {
                            block = Blocks.field_150425_aM.func_176223_P();
                            break;
                        }
                    }
                    if (block != null) {
                        world.func_175656_a(s_pos, block);
                        continue;
                    }
                    if (blockType != ' ') continue;
                    world.func_175698_g(s_pos);
                }
            }
        }
    }

    private boolean getChanceToGenerate(int chance, int chanceOf) {
        int random_chance = (int)(Math.random() * (double)chanceOf);
        return random_chance <= chance;
    }

    private boolean checkAreaForStructure(World world, BlockPos pos, int width, int height, int depth, IBlockState block) {
        for (int xx = pos.func_177958_n(); xx < pos.func_177958_n() + width; ++xx) {
            for (int yy = pos.func_177956_o(); yy < pos.func_177956_o() + height; ++yy) {
                for (int zz = pos.func_177952_p(); zz < pos.func_177952_p() + depth; ++zz) {
                    BlockPos c_pos = new BlockPos(xx, yy, zz);
                    if (world.func_180495_p(c_pos).func_185917_h() && yy != pos.func_177956_o() || world.func_180495_p(c_pos) == block) {
                        return false;
                    }
                    if (world.func_180495_p(c_pos.func_177977_b()) != block) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void generateStructure(World world, BlockPos pos, int width, int height, int depth, IBlockState block) {
        for (int xx = pos.func_177958_n(); xx < pos.func_177958_n() + width; ++xx) {
            for (int yy = pos.func_177956_o(); yy < pos.func_177956_o() + height; ++yy) {
                for (int zz = pos.func_177952_p(); zz < pos.func_177952_p() + depth; ++zz) {
                    BlockPos s_pos;
                    if (yy > pos.func_177956_o() && yy < pos.func_177956_o() + height - 1) {
                        if (xx > pos.func_177958_n() && xx < pos.func_177958_n() + width - 1 && zz > pos.func_177952_p() && zz < pos.func_177952_p() + depth - 1) continue;
                        s_pos = new BlockPos(xx, yy, zz);
                        world.func_175656_a(s_pos, block);
                        continue;
                    }
                    s_pos = new BlockPos(xx, yy, zz);
                    world.func_175656_a(s_pos, block);
                }
            }
        }
    }

    private void generateLine(World world, BlockPos pos, int length, IBlockState block) {
        for (int i = 0; i < length; ++i) {
            world.func_175656_a(pos, block);
            int dir = (int)(Math.random() * 4.0);
            switch (dir) {
                case 0: {
                    pos = pos.func_177974_f();
                    world.func_175656_a(pos, block);
                    pos = pos.func_177974_f();
                    break;
                }
                case 1: {
                    pos = pos.func_177968_d();
                    world.func_175656_a(pos, block);
                    pos = pos.func_177968_d();
                    break;
                }
                case 2: {
                    pos = pos.func_177976_e();
                    world.func_175656_a(pos, block);
                    pos = pos.func_177976_e();
                    break;
                }
                case 3: {
                    pos = pos.func_177978_c();
                    world.func_175656_a(pos, block);
                    pos = pos.func_177978_c();
                }
            }
            if (world.func_180495_p(pos) != block) continue;
            --i;
        }
    }

    private void generateRoom(World world, BlockPos pos, int width, int height, int depth, IBlockState floor, IBlockState walls, IBlockState ceiling) {
        for (int xx = pos.func_177958_n(); xx < pos.func_177958_n() + width; ++xx) {
            for (int yy = pos.func_177956_o(); yy < pos.func_177956_o() + height; ++yy) {
                for (int zz = pos.func_177952_p(); zz < pos.func_177952_p() + depth; ++zz) {
                    BlockPos s_pos = new BlockPos(xx, yy, zz);
                    if (yy > pos.func_177956_o() && yy < pos.func_177956_o() + height - 1) {
                        if (xx > pos.func_177958_n() && xx < pos.func_177958_n() + width - 1 && zz > pos.func_177952_p() && zz < pos.func_177952_p() + depth - 1) {
                            world.func_175698_g(s_pos);
                            continue;
                        }
                        world.func_175656_a(s_pos, walls);
                        continue;
                    }
                    if (s_pos.func_177956_o() == pos.func_177956_o()) {
                        world.func_175656_a(s_pos, floor);
                        continue;
                    }
                    world.func_175656_a(s_pos, ceiling);
                }
            }
        }
    }
}

