/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableListWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class ScrollableArrayTextComponentList
extends ScrollableListWidget<Pair<Integer, ITextComponent>> {
    private static Collection<Pair<Integer, ITextComponent>> getItems(Supplier<ITextComponent[]> baseValueSupplier) {
        ArrayList<Pair<Integer, ITextComponent>> items = new ArrayList<Pair<Integer, ITextComponent>>();
        ITextComponent[] baseValues = baseValueSupplier.get();
        for (int i = 0; i < baseValues.length; ++i) {
            items.add((Pair<Integer, ITextComponent>)Pair.of((Object)i, (Object)baseValues[i]));
        }
        return items;
    }

    private static Supplier<ITextComponent[]> createTextArray(int amount, TextComponent baseName) {
        ITextComponent[] array = new ITextComponent[amount];
        for (int i = 0; i < array.length; ++i) {
            array[i] = baseName.func_230531_f_().func_240702_b_(" " + (i + 1));
        }
        return () -> array;
    }

    public ScrollableArrayTextComponentList(int xPos, int yPos, int width, int height, int itemHeight, @Nonnull Supplier<ITextComponent[]> baseValueSupplier, @Nonnull Consumer<Integer> buttonPressed) {
        super(xPos, yPos, width, height, itemHeight, () -> ScrollableArrayTextComponentList.getItems(baseValueSupplier), (T item, ScrollableListWidget<T> list) -> new TextComponentItem(item, list, buttonPressed));
    }

    public ScrollableArrayTextComponentList(int xPos, int yPos, int width, int height, int itemHeight, int valueAmount, TextComponent baseName, @Nonnull Consumer<Integer> buttonPressed) {
        super(xPos, yPos, width, height, itemHeight, () -> ScrollableArrayTextComponentList.getItems(ScrollableArrayTextComponentList.createTextArray(valueAmount, baseName)), (T item, ScrollableListWidget<T> list) -> new TextComponentItem(item, list, buttonPressed), (ITextComponent)baseName);
    }

    public ScrollableArrayTextComponentList(int xPos, int yPos, int width, int height, int itemHeight, int valueAmount, TextComponent baseName, @Nonnull Consumer<Integer> buttonPressed, @Nullable BiConsumer<Integer, Boolean> onHover) {
        super(xPos, yPos, width, height, itemHeight, () -> ScrollableArrayTextComponentList.getItems(ScrollableArrayTextComponentList.createTextArray(valueAmount, baseName)), (T item, ScrollableListWidget<T> list) -> new TextComponentItem(item, list, buttonPressed, onHover), (ITextComponent)baseName);
    }

    public static class TextComponentItem<T>
    extends ScrollableListWidget.ListItem<Pair<T, ITextComponent>> {
        @Nonnull
        private final Consumer<T> onClick;
        @Nullable
        private final BiConsumer<T, Boolean> onHover;
        private boolean hovered;

        public TextComponentItem(@Nonnull Pair<T, ITextComponent> item, @Nonnull ScrollableListWidget<Pair<T, ITextComponent>> list, @Nonnull Consumer<T> onClick) {
            super(item, list);
            this.onClick = onClick;
            this.onHover = null;
        }

        public TextComponentItem(@Nonnull Pair<T, ITextComponent> item, @Nonnull ScrollableListWidget<Pair<T, ITextComponent>> list, @Nonnull Consumer<T> onClick, @Nullable BiConsumer<T, Boolean> onHover) {
            super(item, list);
            this.onClick = onClick;
            this.onHover = onHover;
        }

        @Override
        public boolean onClick(double mouseX, double mouseY) {
            this.onClick.accept(((Pair)this.item).getLeft());
            return true;
        }

        @Override
        public void render(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int mouseX, int mouseY, float partialTicks, float zLevel) {
            super.render(matrixStack, x - 1, y, listWidth + 1, listHeight, itemHeight, mouseX, mouseY, partialTicks, zLevel);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            int width = font.func_238414_a_((ITextProperties)((Pair)this.item).getRight());
            if (width > listWidth) {
                width = listWidth;
            }
            Minecraft.func_71410_x().field_71466_p.func_243246_a(matrixStack, (ITextComponent)((Pair)this.item).getRight(), (float)(x + listWidth / 2 - width / 2), (float)(y + 7), -1);
            if (this.onHover != null) {
                boolean newHovered;
                boolean bl = newHovered = mouseX >= x && mouseX < x + listWidth && mouseY >= y && mouseY < y + itemHeight;
                if (newHovered != this.hovered) {
                    this.hovered = newHovered;
                    this.onHover(this.hovered);
                }
            }
        }

        protected void onHover(boolean hovered) {
            this.onHover.accept(((Pair)this.item).getLeft(), hovered);
        }
    }
}

