/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.config;

import com.google.common.collect.Maps;
import de.teamlapen.lib.lib.util.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BloodValueLoader
extends ReloadListener<Collection<ResourceLocation>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BLOODVALUEDIRECTORY = "vampirism_blood_values/";
    private final String folderLocation;
    private final String type;
    private final BiConsumer<Map<ResourceLocation, Integer>, Integer> consumer;
    @Nullable
    private final ResourceLocation multiplierName;
    private int multiplier;

    public BloodValueLoader(@Nonnull String nameIn, @Nonnull BiConsumer<Map<ResourceLocation, Integer>, Integer> consumerIn, @Nullable ResourceLocation multiplierNameIn) {
        this.folderLocation = BLOODVALUEDIRECTORY + nameIn;
        this.consumer = consumerIn;
        this.multiplierName = multiplierNameIn;
        this.type = nameIn;
    }

    protected void apply(@Nonnull Collection<ResourceLocation> splashList, @Nonnull IResourceManager resourceManagerIn, @Nonnull IProfiler profilerIn) {
        ConcurrentMap values = Maps.newConcurrentMap();
        for (ResourceLocation location : splashList) {
            String modId;
            Map<ResourceLocation, Integer> values_tmp = this.loadBloodValuesFromDataPack(location, modId = location.func_110623_a().substring(this.folderLocation.length() + 1, location.func_110623_a().length() - 4), resourceManagerIn);
            if (values_tmp == null) continue;
            values.putAll(values_tmp);
            LOGGER.debug(LogUtil.CONFIG, "Loaded {} {} blood values from {}", (Object)values_tmp.size(), (Object)this.type, (Object)modId);
        }
        LOGGER.info(LogUtil.CONFIG, "Loaded {} {} blood values", (Object)values.size(), (Object)this.type);
        this.consumer.accept(values, this.multiplier != 0 ? this.multiplier : 1);
    }

    @Nullable
    protected Map<ResourceLocation, Integer> loadBloodValuesFromDataPack(ResourceLocation location, String modId, IResourceManager resourceManager) {
        if (!ModList.get().isLoaded(modId)) {
            return null;
        }
        try {
            return this.loadBloodValuesFromReader(new InputStreamReader(resourceManager.func_199002_a(location).func_199027_b()), modId);
        }
        catch (IOException e) {
            LOGGER.error(LogUtil.CONFIG, "[ModCompat]Could not read default blood values for mod {}, this should not happen {}", (Object)modId, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Map<ResourceLocation, Integer> loadBloodValuesFromReader(Reader r, String modId) throws IOException {
        ConcurrentMap bloodValues = Maps.newConcurrentMap();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(r);
            while ((line = br.readLine()) != null) {
                int val;
                if (line.startsWith("#") || StringUtils.isBlank((CharSequence)line)) continue;
                String[] p = line.split("=");
                if (p.length != 2) {
                    LOGGER.warn(LogUtil.CONFIG, "Line {}  in {} is not formatted properly", (Object)line, (Object)(modId + ".txt"));
                    continue;
                }
                if (p[0].equals(modId)) {
                    LOGGER.warn(LogUtil.CONFIG, "{} is not applicant for other the mod {} in {}", (Object)line, (Object)modId, (Object)(modId + ".txt"));
                }
                try {
                    val = Integer.parseInt(p[1]);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn(LogUtil.CONFIG, "Line {}  in {} is not formatted properly", (Object)line, (Object)(modId + ".txt"));
                    continue;
                }
                ResourceLocation resourceLocation = new ResourceLocation(p[0]);
                if (!resourceLocation.func_110624_b().equals(modId)) {
                    LOGGER.warn(LogUtil.CONFIG, "Wrong namespace for entry {} in {}", (Object)p[0], (Object)(modId + ".txt"));
                    continue;
                }
                if (resourceLocation.equals((Object)this.multiplierName)) {
                    this.multiplier = val;
                    continue;
                }
                if (bloodValues.put(resourceLocation, val) == null) continue;
                LOGGER.warn(LogUtil.CONFIG, "Duplicated entry for {} is being overridden in {}", (Object)(modId + ".txt"), (Object)p[0]);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Failed to load blood values from reader " + modId, (Throwable)e);
        }
        finally {
            if (br != null) {
                br.close();
            }
            r.close();
        }
        return bloodValues;
    }

    @Nonnull
    protected Collection<ResourceLocation> prepare(IResourceManager resourceManagerIn, @Nonnull IProfiler profilerIn) {
        return resourceManagerIn.func_199003_a(this.folderLocation, file -> file.endsWith(".txt"));
    }
}

