/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BasicEntityAreaParticleCloud
extends Entity {
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(BasicEntityAreaParticleCloud.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> HEIGHT = EntityDataManager.func_187226_a(BasicEntityAreaParticleCloud.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<IParticleData> PARTICLE = EntityDataManager.func_187226_a(BasicEntityAreaParticleCloud.class, (IDataSerializer)DataSerializers.field_198166_i);
    private static final DataParameter<Float> SPAWN_RATE = EntityDataManager.func_187226_a(BasicEntityAreaParticleCloud.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(BasicEntityAreaParticleCloud.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int duration = 60;
    private int waitTime = 0;
    private float radiusPerTick = 0.0f;

    public BasicEntityAreaParticleCloud(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70145_X = true;
        this.setRadius(3.0f);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int colorIn) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)colorIn);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public IParticleData getParticle() {
        return (IParticleData)this.func_184212_Q().func_187225_a(PARTICLE);
    }

    public void setParticle(IParticleData particleData) {
        this.func_184212_Q().func_187227_b(PARTICLE, (Object)particleData);
    }

    public float getRadius() {
        return ((Float)this.func_184212_Q().func_187225_a(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        this.field_213325_aI = new EntitySize(radius * 2.0f, this.func_213302_cg(), this.field_213325_aI.field_220317_c);
        this.func_70107_b(d0, d1, d2);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(RADIUS, (Object)Float.valueOf(radius));
        }
    }

    public float getSpawnRate() {
        return ((Float)this.func_184212_Q().func_187225_a(SPAWN_RATE)).floatValue();
    }

    public void setSpawnRate(float rate) {
        this.func_184212_Q().func_187227_b(SPAWN_RATE, (Object)Float.valueOf(rate));
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public boolean func_70039_c(CompoundNBT compound) {
        return false;
    }

    public void setRadiusPerTick(float radiusPerTick) {
        this.radiusPerTick = radiusPerTick;
    }

    public boolean func_184198_c(CompoundNBT compound) {
        return false;
    }

    public void setHeight(float height) {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        this.field_213325_aI = new EntitySize(this.getRadius() * 2.0f, height, this.field_213325_aI.field_220317_c);
        this.func_70107_b(d0, d1, d2);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(HEIGHT, (Object)Float.valueOf(height));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        float radius = this.getRadius();
        if (this.field_70170_p.field_72995_K) {
            IParticleData particle = this.getParticle();
            float amount = (float)(Math.PI * (double)radius * (double)radius) * this.getSpawnRate();
            int i = 0;
            while ((float)i < amount) {
                float phi = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                float r = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * radius;
                float dx = MathHelper.func_76134_b((float)phi) * r;
                float dz = MathHelper.func_76126_a((float)phi) * r;
                float dy = this.field_70146_Z.nextFloat() * this.func_213302_cg();
                if (particle.func_197554_b() == ParticleTypes.field_197625_r) {
                    int rgb = this.getColor();
                    int cr = rgb >> 16 & 0xFF;
                    int cg = rgb >> 8 & 0xFF;
                    int cb = rgb & 0xFF;
                    this.field_70170_p.func_195594_a(particle, this.func_226277_ct_() + (double)dx, this.func_226278_cu_() + (double)dy, this.func_226281_cx_() + (double)dz, (double)((float)cr / 255.0f), (double)((float)cg / 255.0f), (double)((float)cb / 255.0f));
                } else {
                    this.field_70170_p.func_195594_a(particle, this.func_226277_ct_() + (double)dx, this.func_226278_cu_() + (double)dy, this.func_226281_cx_() + (double)dz, (0.5 - this.field_70146_Z.nextDouble()) * 0.15, (double)0.01f, (0.5 - this.field_70146_Z.nextDouble()) * 0.15);
                }
                ++i;
            }
        } else {
            if (this.field_70173_aa >= this.waitTime + this.duration) {
                this.func_70106_y();
                return;
            }
            if (this.field_70173_aa < this.waitTime) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((radius += this.radiusPerTick) < 0.3f) {
                    this.func_70106_y();
                    return;
                }
                this.setRadius(radius);
            }
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(COLOR, (Object)0);
        this.func_184212_Q().func_187214_a(RADIUS, (Object)Float.valueOf(0.5f));
        this.func_184212_Q().func_187214_a(HEIGHT, (Object)Float.valueOf(0.5f));
        this.func_184212_Q().func_187214_a(PARTICLE, (Object)ParticleTypes.field_197625_r);
        this.func_184212_Q().func_187214_a(SPAWN_RATE, (Object)Float.valueOf(1.0f));
    }

    protected void func_70037_a(CompoundNBT compound) {
    }
}

