/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptifineHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean isLoaded = false;
    private static boolean didCheck = false;
    @Nullable
    private static Method method_isShaders;

    public static boolean isOptifineLoaded() {
        if (didCheck) {
            return isLoaded;
        }
        if (!FMLEnvironment.dist.isClient()) {
            isLoaded = false;
            method_isShaders = null;
            didCheck = true;
            return false;
        }
        try {
            Class<?> configClass = Class.forName("net.optifine.Config");
            isLoaded = true;
            try {
                method_isShaders = configClass.getDeclaredMethod("isShaders", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Could not retrieve shader check method from Optifine config", (Throwable)e);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        didCheck = true;
        return isLoaded;
    }

    public static boolean isShaders() {
        try {
            return method_isShaders != null && (Boolean)method_isShaders.invoke(null, new Object[0]) != false;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }
}

