/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import com.mojang.datafixers.util.Pair;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.general.BloodConversionRegistry;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.modcompat.IntegrationsNotifier;
import de.teamlapen.vampirism.network.BloodValuePacket;
import de.teamlapen.vampirism.network.SkillTreePacket;
import de.teamlapen.vampirism.world.MinionWorldData;
import de.teamlapen.vampirism.world.VampirismWorld;
import java.lang.reflect.Array;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeneralEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public void onAttachCapabilityWorld(AttachCapabilitiesEvent<World> event) {
        event.addCapability(REFERENCE.WORLD_CAP_KEY, VampirismWorld.createNewCapability((World)event.getObject()));
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        boolean isAdminLikePlayer;
        VersionChecker.VersionInfo versionInfo = VampirismMod.instance.getVersionInfo();
        if (!versionInfo.isChecked()) {
            LOGGER.warn("Version check is not finished yet");
        }
        boolean bl = isAdminLikePlayer = !ServerLifecycleHooks.getCurrentServer().func_71262_S() || UtilLib.isPlayerOp(event.getPlayer());
        if (((Boolean)VampirismConfig.COMMON.versionCheck.get()).booleanValue() && versionInfo.isNewVersionAvailable() && (isAdminLikePlayer || event.getPlayer().func_70681_au().nextInt(5) == 0) && event.getPlayer().func_70681_au().nextInt(4) == 0) {
            VersionChecker.Version newVersion = versionInfo.getNewVersion();
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.outdated", new Object[]{versionInfo.getCurrentVersion().name, newVersion.name}), Util.field_240973_b_);
            IFormattableTextComponent download = new TranslationTextComponent("text.vampirism.update_message.download").func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, newVersion.getUrl() == null ? versionInfo.getHomePage() : newVersion.getUrl())).setUnderlined(Boolean.valueOf(true)).func_240721_b_(TextFormatting.BLUE));
            IFormattableTextComponent changelog = new TranslationTextComponent("text.vampirism.update_message.changelog").func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/vampirism changelog")).setUnderlined(Boolean.valueOf(true)));
            IFormattableTextComponent modpage = new TranslationTextComponent("text.vampirism.update_message.modpage").func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, versionInfo.getHomePage())).setUnderlined(Boolean.valueOf(true)).func_240721_b_(TextFormatting.BLUE));
            event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)download).func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_((ITextComponent)changelog).func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_((ITextComponent)modpage), Util.field_240973_b_);
        }
        if (isAdminLikePlayer) {
            List<String> mods = IntegrationsNotifier.shouldNotifyAboutIntegrations();
            if (!mods.isEmpty()) {
                event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.integrations_available.first"), Util.field_240973_b_);
                event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.BLUE + TextFormatting.ITALIC.toString() + StringUtils.join(mods, (String)", ") + TextFormatting.RESET), Util.field_240973_b_);
                event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.integrations_available.download").func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/vampirism-integrations")).setUnderlined(Boolean.valueOf(true))), Util.field_240973_b_);
            }
            if (!ModList.get().isLoaded("guideapi-vp") && ((Boolean)VampirismConfig.SERVER.infoAboutGuideAPI.get()).booleanValue()) {
                event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.guideapi_available.first"), Util.field_240973_b_);
                event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.guideapi_available.download").func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/guide-api-village-and-pillage")).setUnderlined(Boolean.valueOf(true))), Util.field_240973_b_);
                VampirismConfig.SERVER.infoAboutGuideAPI.set((Object)false);
            }
        }
        VampirismMod.dispatcher.sendTo(new SkillTreePacket(VampirismMod.proxy.getSkillTree(false).getCopy()), (ServerPlayerEntity)event.getPlayer());
        Pair[] bloodValues = (Pair[])Array.newInstance(Pair.class, 3);
        bloodValues[0] = new Pair(((VampirismEntityRegistry)VampirismAPI.entityRegistry()).getBloodValues(), (Object)((VampirismEntityRegistry)VampirismAPI.entityRegistry()).getBloodMultiplier());
        bloodValues[1] = new Pair(BloodConversionRegistry.getItemValues(), (Object)BloodConversionRegistry.getItemMultiplier());
        bloodValues[2] = new Pair(BloodConversionRegistry.getFluidValues(), (Object)BloodConversionRegistry.getFluidDivider());
        VampirismMod.dispatcher.sendTo(new BloodValuePacket(bloodValues), (ServerPlayerEntity)event.getPlayer());
        FactionPlayerHandler.getOpt(event.getPlayer()).ifPresent(FactionPlayerHandler::onPlayerLoggedIn);
        if (!PermissionAPI.hasPermission((PlayerEntity)event.getPlayer(), (String)"vampirism.check")) {
            event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent("[" + TextFormatting.DARK_PURPLE + "Vampirism" + TextFormatting.RESET + "] It seems like the permission plugin used is not properly set up. Make sure all players have 'vampirism.*' for the mod to work (or at least '" + "vampirism.check" + "' to suppress this warning)."), Util.field_240973_b_);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        MinionWorldData.getData(ServerLifecycleHooks.getCurrentServer()).tick();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld w = (ServerWorld)event.getWorld();
            ServerChunkProvider p = w.func_72863_F();
            ModFeatures.checkWorldStructureSeparation((RegistryKey<World>)w.func_234923_W_(), p.func_201711_g() instanceof FlatChunkGenerator, p.func_201711_g().func_235957_b_());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof World) {
            VampirismWorld.getOpt((World)event.getWorld()).ifPresent(VampirismWorld::clear);
        }
    }
}

