/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.actions;

import de.teamlapen.vampirism.api.entity.effect.EffectInstanceWithSource;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class DefaultAction<T extends IFactionPlayer>
extends ForgeRegistryEntry<IAction>
implements IAction {
    private ITextComponent name;

    public void addEffectInstance(T player, EffectInstance instance) {
        ((EffectInstanceWithSource)instance).setSource(this.getRegistryName());
        player.getRepresentingPlayer().func_195064_c(instance);
    }

    public boolean canBeUsedBy(T player) {
        return true;
    }

    @Override
    public IAction.PERM canUse(IFactionPlayer player) {
        if (!this.isEnabled()) {
            return IAction.PERM.DISABLED;
        }
        if (this.getFaction().getFactionPlayerInterface().isInstance(player)) {
            return this.canBeUsedBy(player) ? IAction.PERM.ALLOWED : IAction.PERM.DISALLOWED;
        }
        throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.getFaction().getFactionPlayerInterface());
    }

    @Override
    public ITextComponent getName() {
        return this.name == null ? (this.name = new TranslationTextComponent(this.getTranslationKey())) : this.name;
    }

    @Override
    @Deprecated
    public String getTranslationKey() {
        return "action." + this.getRegistryName().func_110624_b() + "." + this.getRegistryName().func_110623_a();
    }

    public abstract boolean isEnabled();

    @Override
    public boolean onActivated(IFactionPlayer player) {
        if (this.getFaction().getFactionPlayerInterface().isInstance(player)) {
            return this.activate(player);
        }
        throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.getFaction().getFactionPlayerInterface());
    }

    public void removePotionEffect(T player, Effect effect) {
        EffectInstance ins = player.getRepresentingPlayer().func_70660_b(effect);
        while (ins != null) {
            EffectInstanceWithSource insM = (EffectInstanceWithSource)ins;
            if (insM.hasSource() && insM.getSource().equals((Object)this.getRegistryName())) {
                insM.removeEffect();
                break;
            }
            ins = insM.getHiddenEffect();
        }
    }

    public String toString() {
        return this.getRegistryName() + " (" + this.getClass().getSimpleName() + ")";
    }

    protected abstract boolean activate(T var1);
}

