/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.items;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

public interface IFactionLevelItem<T extends IFactionPlayer> {
    @OnlyIn(value=Dist.CLIENT)
    default public void addFactionLevelToolTip(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn, @Nullable PlayerEntity player) {
        TextFormatting factionC = TextFormatting.DARK_RED;
        TextFormatting levelC = TextFormatting.DARK_RED;
        TextFormatting skillC = TextFormatting.DARK_RED;
        LazyOptional<IFactionPlayerHandler> playerHandler = player != null && player.func_70089_S() ? VampirismAPI.getFactionPlayerHandler(player) : LazyOptional.empty();
        IPlayableFaction usingFaction = this.getUsingFaction(stack);
        ISkill requiredSkill = this.getRequiredSkill(stack);
        int reqLevel = this.getMinLevel(stack);
        if (playerHandler.map(p -> p.isInFaction(usingFaction)).orElse(false).booleanValue()) {
            factionC = TextFormatting.GREEN;
            if (playerHandler.map(IFactionPlayerHandler::getCurrentLevel).orElse(0) >= reqLevel) {
                levelC = TextFormatting.GREEN;
            }
            if (playerHandler.map(IFactionPlayerHandler::getCurrentFactionPlayer).flatMap(a -> a.map(b -> b.getSkillHandler().isSkillEnabled(requiredSkill))).orElse(false).booleanValue()) {
                skillC = TextFormatting.GREEN;
            }
        }
        if (usingFaction == null && this.getMinLevel(stack) == 0) {
            return;
        }
        IFormattableTextComponent string = new StringTextComponent("").func_230529_a_((ITextComponent)(usingFaction == null ? new TranslationTextComponent("text.vampirism.all") : usingFaction.getNamePlural())).func_240699_a_(factionC);
        if (this.getMinLevel(stack) > 0) {
            string.func_230529_a_((ITextComponent)new StringTextComponent("@" + this.getMinLevel(stack)).func_240699_a_(levelC));
        }
        tooltip.add((ITextComponent)string);
        ISkill reqSkill = this.getRequiredSkill(stack);
        if (reqSkill != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("text.vampirism.required_skill", new Object[]{reqSkill.getName()}).func_240699_a_(skillC));
        }
    }

    public int getMinLevel(@Nonnull ItemStack var1);

    @Nullable
    public ISkill getRequiredSkill(@Nonnull ItemStack var1);

    @Nullable
    public IPlayableFaction<T> getUsingFaction(@Nonnull ItemStack var1);
}

