/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.tileentity.AlchemicalCauldronTileEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlchemicalCauldronBlock
extends AbstractFurnaceBlock {
    public static final String regName = "alchemical_cauldron";
    public static final IntegerProperty LIQUID = IntegerProperty.func_177719_a((String)"liquid", (int)0, (int)2);
    protected static final VoxelShape cauldronShape = AlchemicalCauldronBlock.makeShape();

    private static VoxelShape makeShape() {
        VoxelShape a = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
        VoxelShape b = Block.func_208617_a((double)1.0, (double)9.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0);
        VoxelShape c = Block.func_208617_a((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        return VoxelShapes.func_216384_a((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c});
    }

    public AlchemicalCauldronBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(4.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIQUID, (Comparable)Integer.valueOf(0))).func_206870_a((Property)field_220090_a, (Comparable)Direction.NORTH)).func_206870_a((Property)field_220091_b, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("vampirism", regName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rng) {
        super.func_180655_c(state, world, pos, rng);
        if ((Integer)state.func_177229_b((Property)LIQUID) == 2) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, ModSounds.boiling, SoundCategory.BLOCKS, 0.05f, 1.0f, false);
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new AlchemicalCauldronTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return cauldronShape;
    }

    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, LivingEntity entity, ItemStack stack) {
        super.func_180633_a(world, blockPos, blockState, entity, stack);
        TileEntity tile = world.func_175625_s(blockPos);
        if (entity instanceof PlayerEntity && tile instanceof AlchemicalCauldronTileEntity) {
            ((AlchemicalCauldronTileEntity)tile).setOwnerID((PlayerEntity)entity);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_220091_b, field_220090_a, LIQUID});
    }

    protected void func_220089_a(World world, BlockPos blockPos, PlayerEntity playerEntity) {
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile instanceof AlchemicalCauldronTileEntity) {
            playerEntity.func_213829_a((INamedContainerProvider)tile);
            playerEntity.func_195066_a(ModStats.interact_alchemical_cauldron);
        }
    }
}

