/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.inventory.container.HunterTableContainer;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class HunterTableBlock
extends VampirismHorizontalBlock {
    public static final String name = "hunter_table";
    public static final EnumProperty<TABLE_VARIANT> VARIANT = EnumProperty.func_177709_a((String)"variant", TABLE_VARIANT.class);
    private static final VoxelShape SOUTH = HunterTableBlock.makeShape();
    private static final VoxelShape WEST = UtilLib.rotateShape(SOUTH, UtilLib.RotationAmount.NINETY);
    private static final VoxelShape NORTH = UtilLib.rotateShape(SOUTH, UtilLib.RotationAmount.HUNDRED_EIGHTY);
    private static final VoxelShape EAST = UtilLib.rotateShape(SOUTH, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);

    private static VoxelShape makeShape() {
        VoxelShape a = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)10.0, (double)2.0);
        VoxelShape b = Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)2.0);
        VoxelShape c = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)10.0, (double)16.0);
        VoxelShape d = Block.func_208617_a((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)10.0, (double)16.0);
        VoxelShape e = Block.func_208617_a((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
        VoxelShape f = Block.func_208617_a((double)8.5, (double)10.0, (double)3.5, (double)13.5, (double)11.0, (double)10.0);
        VoxelShape d1 = VoxelShapes.func_197872_a((VoxelShape)a, (VoxelShape)b);
        VoxelShape d2 = VoxelShapes.func_197872_a((VoxelShape)c, (VoxelShape)d);
        VoxelShape d3 = VoxelShapes.func_197872_a((VoxelShape)d1, (VoxelShape)d2);
        VoxelShape f1 = VoxelShapes.func_197872_a((VoxelShape)e, (VoxelShape)f);
        return VoxelShapes.func_197872_a((VoxelShape)d3, (VoxelShape)f1);
    }

    public static TABLE_VARIANT getTierFor(boolean weapon_table, boolean potion_table, boolean cauldron) {
        return weapon_table ? (potion_table ? (cauldron ? TABLE_VARIANT.COMPLETE : TABLE_VARIANT.WEAPON_POTION) : (cauldron ? TABLE_VARIANT.WEAPON_CAULDRON : TABLE_VARIANT.WEAPON)) : (potion_table ? (cauldron ? TABLE_VARIANT.POTION_CAULDRON : TABLE_VARIANT.POTION) : (cauldron ? TABLE_VARIANT.CAULDRON : TABLE_VARIANT.SIMPLE));
    }

    public HunterTableBlock() {
        super(name, AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(0.5f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(VARIANT, (Comparable)((Object)TABLE_VARIANT.SIMPLE)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return NORTH;
            }
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
        }
        return NORTH;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_195992_f();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)facing)).func_206870_a(VARIANT, (Comparable)((Object)this.determineTier((IWorldReader)context.func_195991_k(), context.func_195995_a(), facing)));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (fromPos.func_177956_o() != pos.func_177956_o()) {
            return;
        }
        TABLE_VARIANT newVariant = this.determineTier((IWorldReader)worldIn, pos, (Direction)state.func_177229_b((Property)FACING));
        if (newVariant != state.func_177229_b(VARIANT)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)newVariant)), 2);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, playerIn) -> new HunterTableContainer(id, playerInventory, IWorldPosCallable.func_221488_a((World)playerIn.field_70170_p, (BlockPos)pos)), (ITextComponent)new TranslationTextComponent("container.crafting")), (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, VARIANT});
    }

    protected TABLE_VARIANT determineTier(IWorldReader world, BlockPos pos, Direction facing) {
        Block behind = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        Block left = world.func_180495_p(pos.func_177972_a(facing.func_176746_e())).func_177230_c();
        Block right = world.func_180495_p(pos.func_177972_a(facing.func_176735_f())).func_177230_c();
        Block front = world.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c();
        boolean weapon_table = left == ModBlocks.weapon_table || right == ModBlocks.weapon_table || behind == ModBlocks.weapon_table || front == ModBlocks.weapon_table;
        boolean potion_table = left == ModBlocks.potion_table || right == ModBlocks.potion_table || behind == ModBlocks.potion_table || front == ModBlocks.potion_table;
        boolean cauldron = left == ModBlocks.alchemical_cauldron || right == ModBlocks.alchemical_cauldron || behind == ModBlocks.alchemical_cauldron || front == ModBlocks.alchemical_cauldron;
        return HunterTableBlock.getTierFor(weapon_table, potion_table, cauldron);
    }

    public static enum TABLE_VARIANT implements IStringSerializable
    {
        SIMPLE("simple", 0),
        WEAPON("weapon", 1),
        CAULDRON("cauldron", 1),
        POTION("potion", 1),
        WEAPON_CAULDRON("weapon_cauldron", 2),
        WEAPON_POTION("weapon_potion", 2),
        POTION_CAULDRON("potion_cauldron", 2),
        COMPLETE("complete", 3);

        public final String name;
        public final int tier;

        private TABLE_VARIANT(String n2, int tier) {
            this.name = n2;
            this.tier = tier;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

