/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MedChairBlock
extends VampirismHorizontalBlock {
    public static final EnumProperty<EnumPart> PART = EnumProperty.func_177709_a((String)"part", EnumPart.class);
    private static final String name = "med_chair";
    private final VoxelShape SHAPE_TOP;
    private final VoxelShape SHAPE_BOTTOM;

    public MedChairBlock() {
        super(name, AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(1.0f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(PART, (Comparable)((Object)EnumPart.TOP)));
        this.SHAPE_TOP = MedChairBlock.func_208617_a((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
        this.SHAPE_BOTTOM = MedChairBlock.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0);
    }

    @Nonnull
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)ModItems.item_med_chair);
    }

    @Override
    @Nonnull
    public VoxelShape func_220053_a(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return state.func_177229_b(PART) == EnumPart.BOTTOM ? this.SHAPE_BOTTOM : this.SHAPE_TOP;
    }

    public void func_180657_a(@Nonnull World worldIn, @Nonnull PlayerEntity player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable TileEntity te, @Nonnull ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public void func_176208_a(@Nonnull World worldIn, @Nonnull BlockPos pos, BlockState state, @Nonnull PlayerEntity player) {
        EnumPart part = (EnumPart)((Object)state.func_177229_b(PART));
        Direction dir = (Direction)state.func_177229_b((Property)FACING);
        BlockPos other = state.func_177229_b(PART) == EnumPart.TOP ? pos.func_177972_a(dir) : pos.func_177972_a(dir.func_176734_d());
        BlockState otherState = worldIn.func_180495_p(other);
        if (otherState.func_177230_c() == this && otherState.func_177229_b(PART) != part) {
            worldIn.func_180501_a(other, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, other, Block.func_196246_j((BlockState)otherState));
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                ItemStack itemstack = player.func_184614_ca();
                MedChairBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)itemstack);
                MedChairBlock.func_220054_a((BlockState)otherState, (World)worldIn, (BlockPos)other, null, (Entity)player, (ItemStack)itemstack);
            }
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        if (player.func_70089_S()) {
            ItemStack stack = player.func_184586_b(hand);
            if (this.handleInjections(player, world, stack)) {
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.field_71071_by.func_184437_d(stack);
                }
            }
        } else if (world.field_72995_K) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.need_item_to_use", new Object[]{new TranslationTextComponent(new ItemStack((IItemProvider)ModItems.injection_garlic).func_77977_a())}), true);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, PART});
    }

    private boolean handleGarlicInjection(@Nonnull PlayerEntity player, @Nonnull World world, @Nonnull IFactionPlayerHandler handler, @Nullable IPlayableFaction<?> currentFaction) {
        if (handler.canJoin(VReference.HUNTER_FACTION)) {
            if (world.field_72995_K) {
                VampirismMod.proxy.renderScreenFullColor(4, 30, -1145324545);
            } else {
                handler.joinFaction(VReference.HUNTER_FACTION);
                player.func_195064_c(new EffectInstance(ModEffects.poison, 200, 1));
            }
            return true;
        }
        if (currentFaction != null && !world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.med_chair_other_faction", new Object[]{currentFaction.getName()}), Util.field_240973_b_);
        }
        return false;
    }

    private boolean handleInjections(PlayerEntity player, World world, ItemStack stack) {
        FactionPlayerHandler handler = FactionPlayerHandler.get(player);
        IPlayableFaction<? extends IFactionPlayer<?>> faction = handler.getCurrentFaction();
        if (stack.func_77973_b().equals((Object)ModItems.injection_garlic)) {
            return this.handleGarlicInjection(player, world, handler, faction);
        }
        if (stack.func_77973_b().equals((Object)ModItems.injection_sanguinare)) {
            return this.handleSanguinareInjection(player, handler, faction);
        }
        if (stack.func_77973_b().equals((Object)ModItems.injection_zombie_blood)) {
            return this.handleZombieBloodInjection(player);
        }
        return false;
    }

    private boolean handleSanguinareInjection(@Nonnull PlayerEntity player, @Nonnull IFactionPlayerHandler handler, @Nullable IPlayableFaction<?> currentFaction) {
        if (VReference.VAMPIRE_FACTION.equals(currentFaction)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.already_vampire"), false);
            return false;
        }
        if (VReference.HUNTER_FACTION.equals(currentFaction)) {
            VampirismMod.proxy.displayRevertBackScreen();
            return true;
        }
        if (currentFaction == null && handler.canJoin(VReference.VAMPIRE_FACTION)) {
            if (((Boolean)VampirismConfig.SERVER.disableFangInfection.get()).booleanValue()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.deactivated_by_serveradmin"), true);
            } else {
                SanguinareEffect.addRandom((LivingEntity)player, true);
                player.func_195064_c(new EffectInstance(ModEffects.poison, 60));
                return true;
            }
        }
        return false;
    }

    private boolean handleZombieBloodInjection(@Nonnull PlayerEntity player) {
        player.func_195064_c(new EffectInstance(ModEffects.poison, 200));
        return true;
    }

    public static enum EnumPart implements IStringSerializable
    {
        TOP("top", 0),
        BOTTOM("bottom", 1);

        public final String name;
        public final int meta;

        public static EnumPart fromMeta(int meta) {
            if (meta == 1) {
                return BOTTOM;
            }
            return TOP;
        }

        private EnumPart(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

