/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.model.blocks.BakedAltarInspirationModel;
import de.teamlapen.vampirism.client.model.blocks.BakedBloodContainerModel;
import de.teamlapen.vampirism.client.model.blocks.BakedWeaponTableModel;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.effects.VampirismPotion;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.proxy.ClientProxy;
import de.teamlapen.vampirism.util.Helper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onModelBakeEvent(ModelBakeEvent event) {
        Object newModel;
        IBakedModel registeredModel;
        ArrayList modelLocations;
        Object model;
        ResourceLocation loc;
        try {
            for (int x = 0; x < 14; ++x) {
                loc = new ResourceLocation("vampirism", "block/blood_container/fluid_" + (x + 1));
                model = event.getModelLoader().getModelOrMissing(loc);
                BakedBloodContainerModel.BLOOD_FLUID_MODELS[x] = model.func_225613_a_((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y0, loc);
                if (model instanceof BlockModel) {
                    ((BlockModel)model).field_178318_c.put("fluid", Either.left((Object)ForgeHooksClient.getBlockMaterial((ResourceLocation)ModFluids.impure_blood.getAttributes().getStillTexture())));
                    BakedBloodContainerModel.IMPURE_BLOOD_FLUID_MODELS[x] = model.func_225613_a_((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y0, loc);
                    continue;
                }
                LOGGER.error("Cannot apply impure blood texture to blood container model {}", model);
                BakedBloodContainerModel.IMPURE_BLOOD_FLUID_MODELS[x] = BakedBloodContainerModel.BLOOD_FLUID_MODELS[x];
            }
            Map registry = event.getModelRegistry();
            modelLocations = Lists.newArrayList();
            for (ResourceLocation modelLoc : registry.keySet()) {
                if (!modelLoc.func_110624_b().equals("vampirism") || !modelLoc.func_110623_a().equals("blood_container")) continue;
                modelLocations.add(modelLoc);
            }
            for (ResourceLocation loc2 : modelLocations) {
                registeredModel = (IBakedModel)event.getModelRegistry().get(loc2);
                newModel = new BakedBloodContainerModel(registeredModel);
                event.getModelRegistry().put(loc2, newModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load fluid models for blood container", (Throwable)e);
        }
        try {
            for (int x = 0; x < 10; ++x) {
                loc = new ResourceLocation("vampirism", "block/altar_inspiration/blood" + (x + 1));
                model = event.getModelLoader().getModelOrMissing(loc);
                BakedAltarInspirationModel.FLUID_MODELS[x] = model.func_225613_a_((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y0, loc);
            }
            Map registry = event.getModelRegistry();
            modelLocations = Lists.newArrayList();
            for (ResourceLocation modelLoc : registry.keySet()) {
                if (!modelLoc.func_110624_b().equals("vampirism") || !modelLoc.func_110623_a().equals("altar_inspiration")) continue;
                modelLocations.add(modelLoc);
            }
            for (ResourceLocation loc2 : modelLocations) {
                registeredModel = (IBakedModel)event.getModelRegistry().get(loc2);
                newModel = new BakedAltarInspirationModel(registeredModel);
                event.getModelRegistry().put(loc2, newModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load fluid models for altar inspiration", (Throwable)e);
        }
        try {
            for (int x = 0; x < 5; ++x) {
                loc = new ResourceLocation("vampirism", "block/weapon_table/weapon_table_lava" + (x + 1));
                model = event.getModelLoader().getModelOrMissing(loc);
                BakedWeaponTableModel.FLUID_MODELS[x][0] = model.func_225613_a_((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y180, loc);
                BakedWeaponTableModel.FLUID_MODELS[x][1] = model.func_225613_a_((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y270, loc);
                BakedWeaponTableModel.FLUID_MODELS[x][2] = model.func_225613_a_((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y0, loc);
                BakedWeaponTableModel.FLUID_MODELS[x][3] = model.func_225613_a_((ModelBakery)event.getModelLoader(), ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y90, loc);
            }
            Map registry = event.getModelRegistry();
            modelLocations = Lists.newArrayList();
            for (ResourceLocation modelLoc : registry.keySet()) {
                if (!modelLoc.func_110624_b().equals("vampirism") || !modelLoc.func_110623_a().equals("weapon_table")) continue;
                modelLocations.add(modelLoc);
            }
            for (ResourceLocation loc2 : modelLocations) {
                registeredModel = (IBakedModel)event.getModelRegistry().get(loc2);
                newModel = new BakedWeaponTableModel(registeredModel);
                event.getModelRegistry().put(loc2, newModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load fluid models for weapon crafting table", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onFovOffsetUpdate(FOVUpdateEvent event) {
        if (((Boolean)VampirismConfig.CLIENT.disableFovChange.get()).booleanValue() && Helper.isVampire(event.getEntity())) {
            ModifiableAttributeInstance speed = event.getEntity().func_110148_a(Attributes.field_233821_d_);
            AttributeModifier vampirespeed = speed.func_111127_a(LevelAttributeModifier.getUUID(Attributes.field_233821_d_));
            if (vampirespeed == null) {
                return;
            }
            event.setNewfov((float)((double)event.getFov() * ((vampirespeed.func_111164_d() + 1.0) * (double)event.getEntity().field_71075_bZ.func_75094_b() + speed.func_111126_e()) / ((vampirespeed.func_111164_d() + 1.0) * ((double)event.getEntity().field_71075_bZ.func_75094_b() + speed.func_111126_e()))));
        }
    }

    @SubscribeEvent
    public void onToolTip(ItemTooltipEvent event) {
        if (VampirismPotion.isHunterPotion(event.getItemStack(), true).map(Potion::func_185170_a).map(effectInstances -> effectInstances.stream().map(EffectInstance::func_188419_a).anyMatch(Effect::func_188408_i)).orElse(false).booleanValue() && (event.getPlayer() == null || !Helper.isHunter(event.getPlayer()))) {
            event.getToolTip().add(new TranslationTextComponent("text.vampirism.hunter_potion.deadly").func_240699_a_(TextFormatting.DARK_RED));
        }
    }

    @SubscribeEvent
    public void onWorldClosed(WorldEvent.Unload event) {
        ((ClientProxy)VampirismMod.proxy).clearBossBarOverlay();
    }
}

