/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import de.teamlapen.lib.lib.client.render.RenderAreaParticleCloud;
import de.teamlapen.vampirism.client.render.entities.AdvancedHunterRenderer;
import de.teamlapen.vampirism.client.render.entities.AdvancedVampireRenderer;
import de.teamlapen.vampirism.client.render.entities.BasicHunterRenderer;
import de.teamlapen.vampirism.client.render.entities.BasicVampireRenderer;
import de.teamlapen.vampirism.client.render.entities.ConvertedChestedHorseRenderer;
import de.teamlapen.vampirism.client.render.entities.ConvertedCreatureRenderer;
import de.teamlapen.vampirism.client.render.entities.ConvertedVillagerRenderer;
import de.teamlapen.vampirism.client.render.entities.CrossbowArrowRenderer;
import de.teamlapen.vampirism.client.render.entities.DarkBloodProjectileRenderer;
import de.teamlapen.vampirism.client.render.entities.DummyRenderer;
import de.teamlapen.vampirism.client.render.entities.HunterMinionRenderer;
import de.teamlapen.vampirism.client.render.entities.HunterTaskMasterRenderer;
import de.teamlapen.vampirism.client.render.entities.HunterTrainerRenderer;
import de.teamlapen.vampirism.client.render.entities.HunterVillagerRenderer;
import de.teamlapen.vampirism.client.render.entities.SoulOrbRenderer;
import de.teamlapen.vampirism.client.render.entities.ThrowableItemRenderer;
import de.teamlapen.vampirism.client.render.entities.VampireBaronRenderer;
import de.teamlapen.vampirism.client.render.entities.VampireMinionRenderer;
import de.teamlapen.vampirism.client.render.entities.VampireTaskMasterRenderer;
import de.teamlapen.vampirism.client.render.layers.VampireEntityLayer;
import de.teamlapen.vampirism.core.ModEntities;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.BatRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import org.apache.logging.log4j.LogManager;

@OnlyIn(value=Dist.CLIENT)
public class ModEntitiesRender {
    public static void registerEntityRenderer(Supplier<Minecraft> minecraftSupplier) {
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.blinding_bat, ModEntitiesRender.safeFactory(BatRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.converted_creature_imob, ModEntitiesRender.safeFactory(ConvertedCreatureRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.converted_creature, ModEntitiesRender.safeFactory(ConvertedCreatureRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.converted_horse, renderingManager -> {
            HorseRenderer renderer = new HorseRenderer(renderingManager);
            renderer.func_177094_a(new VampireEntityLayer(renderer, new ResourceLocation("vampirism", "textures/entity/vanilla/horse_overlay.png"), false));
            return renderer;
        });
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.converted_donkey, ModEntitiesRender.safeFactory(ConvertedChestedHorseRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.converted_mule, ModEntitiesRender.safeFactory(ConvertedChestedHorseRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.converted_sheep, ModEntitiesRender.safeFactory(ConvertedCreatureRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.converted_cow, ModEntitiesRender.safeFactory(ConvertedCreatureRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.hunter, ModEntitiesRender.safeFactory(BasicHunterRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.hunter_imob, ModEntitiesRender.safeFactory(BasicHunterRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.vampire, ModEntitiesRender.safeFactory(BasicVampireRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.vampire_imob, ModEntitiesRender.safeFactory(BasicVampireRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.hunter_trainer, e -> new HunterTrainerRenderer(e, true));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.vampire_baron, ModEntitiesRender.safeFactory(VampireBaronRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.advanced_hunter, ModEntitiesRender.safeFactory(AdvancedHunterRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.advanced_hunter_imob, ModEntitiesRender.safeFactory(AdvancedHunterRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.advanced_vampire, ModEntitiesRender.safeFactory(AdvancedVampireRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.advanced_vampire_imob, ModEntitiesRender.safeFactory(AdvancedVampireRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.villager_converted, ModEntitiesRender.safeFactory(ConvertedVillagerRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.villager_angry, renderManager -> new HunterVillagerRenderer(renderManager, (IReloadableResourceManager)((Minecraft)minecraftSupplier.get()).func_195551_G()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.crossbow_arrow, ModEntitiesRender.safeFactory(CrossbowArrowRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.particle_cloud, ModEntitiesRender.safeFactory(RenderAreaParticleCloud::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.throwable_item, manager -> new ThrowableItemRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.dark_blood_projectile, ModEntitiesRender.safeFactory(DarkBloodProjectileRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.soul_orb, manager -> new SoulOrbRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.hunter_trainer_dummy, e -> new HunterTrainerRenderer(e, false));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.dummy_creature, ModEntitiesRender.safeFactory(DummyRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.vampire_minion, ModEntitiesRender.safeFactory(VampireMinionRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.hunter_minion, ModEntitiesRender.safeFactory(HunterMinionRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.task_master_vampire, ModEntitiesRender.safeFactory(VampireTaskMasterRenderer::new));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.task_master_hunter, ModEntitiesRender.safeFactory(HunterTaskMasterRenderer::new));
    }

    private static <T extends Entity> IRenderFactory<? super T> safeFactory(IRenderFactory<? super T> f) {
        return manager -> {
            try {
                return f.createRenderFor(manager);
            }
            catch (Exception e) {
                LogManager.getLogger().error("Failed to instantiate entity renderer", (Throwable)e);
                System.exit(0);
                throw e;
            }
        };
    }
}

