/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.client.gui.SelectActionScreen;
import de.teamlapen.vampirism.client.gui.SelectMinionTaskScreen;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModKeys {
    private static final Logger LOGGER = LogManager.getLogger(ModKeys.class);
    private static final long ACTION_BUTTON_COOLDOWN = 500L;
    private static final String CATEGORY = "keys.vampirism.category";
    private static final String SUCK_BLOOD = "keys.vampirism.suck";
    private static final String TOGGLE_ACTIONS = "keys.vampirism.action";
    private static final String SELECT_SKILLS = "keys.vampirism.select_skills";
    private static final String SWITCH_VISION = "keys.vampirism.vision";
    private static final String ACTIVATE_ACTION1 = "keys.vampirism.action1";
    private static final String ACTIVATE_ACTION2 = "keys.vampirism.action2";
    private static final String ACTIVATE_ACTION3 = "keys.vampirism.action3";
    private static final String MINION_TASK = "keys.vampirism.minion_task";
    private static final KeyBinding SUCK = new KeyBinding("keys.vampirism.suck", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 86, "keys.vampirism.category");
    private static final KeyBinding ACTION = new KeyBinding("keys.vampirism.action", InputMappings.Type.KEYSYM, 82, "keys.vampirism.category");
    private static final KeyBinding SKILL = new KeyBinding("keys.vampirism.select_skills", InputMappings.Type.KEYSYM, 80, "keys.vampirism.category");
    private static final KeyBinding VISION = new KeyBinding("keys.vampirism.vision", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 78, "keys.vampirism.category");
    private static final KeyBinding ACTION1 = new KeyBinding("keys.vampirism.action1", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputMappings.Type.KEYSYM, 49, "keys.vampirism.category");
    private static final KeyBinding ACTION2 = new KeyBinding("keys.vampirism.action2", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputMappings.Type.KEYSYM, 50, "keys.vampirism.category");
    private static final KeyBinding ACTION3 = new KeyBinding("keys.vampirism.action3", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputMappings.Type.KEYSYM, 51, "keys.vampirism.category");
    private static final KeyBinding MINION = new KeyBinding("keys.vampirism.minion_task", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.field_197958_a, "keys.vampirism.category");
    private boolean suckKeyDown = false;
    private long lastAction1Trigger = 0L;
    private long lastAction2Trigger = 0L;
    private long lastAction3Trigger = 0L;

    @Nonnull
    public static KeyBinding getKeyBinding(@Nonnull KEY key) {
        switch (key) {
            case SUCK: {
                return SUCK;
            }
            case ACTION: {
                return ACTION;
            }
            case SKILL: {
                return SKILL;
            }
            case VISION: {
                return VISION;
            }
            case ACTION1: {
                return ACTION1;
            }
            case ACTION2: {
                return ACTION2;
            }
            case ACTION3: {
                return ACTION3;
            }
            case MINION: {
                return MINION;
            }
        }
        LOGGER.error("Keybinding {} does not exist", (Object)key);
        return ACTION;
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new ModKeys());
        ClientRegistry.registerKeyBinding((KeyBinding)ACTION);
        ClientRegistry.registerKeyBinding((KeyBinding)SUCK);
        ClientRegistry.registerKeyBinding((KeyBinding)SKILL);
        ClientRegistry.registerKeyBinding((KeyBinding)VISION);
        ClientRegistry.registerKeyBinding((KeyBinding)ACTION1);
        ClientRegistry.registerKeyBinding((KeyBinding)ACTION2);
        ClientRegistry.registerKeyBinding((KeyBinding)ACTION3);
        ClientRegistry.registerKeyBinding((KeyBinding)MINION);
    }

    private ModKeys() {
    }

    @SubscribeEvent
    public void handleInputEvent(InputEvent event) {
        KEY keyPressed = this.getPressedKeyBinding();
        if (!this.suckKeyDown && keyPressed == KEY.SUCK) {
            RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
            this.suckKeyDown = true;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (mouseOver != null && !player.func_175149_v() && VampirePlayer.getOpt((PlayerEntity)player).map(vp -> vp.getLevel() > 0 && !vp.getActionHandler().isActionActive(VampireActions.bat)).orElse(false).booleanValue()) {
                if (mouseOver instanceof EntityRayTraceResult) {
                    VampirismMod.dispatcher.sendToServer(new InputEventPacket("sb", "" + ((EntityRayTraceResult)mouseOver).func_216348_a().func_145782_y()));
                } else if (mouseOver instanceof BlockRayTraceResult) {
                    BlockPos pos = ((BlockRayTraceResult)mouseOver).func_216350_a();
                    VampirismMod.dispatcher.sendToServer(new InputEventPacket("db", "" + pos.func_177958_n() + ":" + pos.func_177956_o() + ":" + pos.func_177952_p()));
                } else {
                    VampirismMod.dispatcher.sendToServer(new InputEventPacket("sb", "-1"));
                }
            }
        } else if (keyPressed == KEY.ACTION) {
            IPlayableFaction<IFactionPlayer<?>> faction;
            if (Minecraft.func_71410_x().field_71439_g.func_70089_S() && (faction = VampirismPlayerAttributes.get((PlayerEntity)Minecraft.func_71410_x().field_71439_g).faction) != null) {
                Minecraft.func_71410_x().func_147108_a((Screen)new SelectActionScreen(faction.getColor(), false));
            }
        } else if (keyPressed == KEY.SKILL) {
            VampirismMod.dispatcher.sendToServer(new InputEventPacket("ovm", ""));
        } else if (keyPressed == KEY.VISION) {
            VampirismMod.dispatcher.sendToServer(new InputEventPacket("vvt", ""));
        } else if (keyPressed == KEY.ACTION1) {
            long t = System.currentTimeMillis();
            if (t - this.lastAction1Trigger > 500L) {
                this.lastAction1Trigger = System.currentTimeMillis();
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player.func_70089_S()) {
                    FactionPlayerHandler.getOpt((PlayerEntity)player).ifPresent(factionHandler -> factionHandler.getCurrentFactionPlayer().ifPresent(factionPlayer -> this.toggleBoundAction((IFactionPlayer)factionPlayer, factionHandler.getBoundAction(1))));
                }
            }
        } else if (keyPressed == KEY.ACTION2) {
            long t = System.currentTimeMillis();
            if (t - this.lastAction2Trigger > 500L) {
                this.lastAction2Trigger = System.currentTimeMillis();
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player.func_70089_S()) {
                    FactionPlayerHandler.getOpt((PlayerEntity)player).ifPresent(factionHandler -> factionHandler.getCurrentFactionPlayer().ifPresent(factionPlayer -> this.toggleBoundAction((IFactionPlayer)factionPlayer, factionHandler.getBoundAction(2))));
                }
            }
        } else if (keyPressed == KEY.ACTION3) {
            long t = System.currentTimeMillis();
            if (t - this.lastAction3Trigger > 500L) {
                this.lastAction3Trigger = System.currentTimeMillis();
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player.func_70089_S()) {
                    FactionPlayerHandler.getOpt((PlayerEntity)player).ifPresent(factionHandler -> factionHandler.getCurrentFactionPlayer().ifPresent(factionPlayer -> this.toggleBoundAction((IFactionPlayer)factionPlayer, factionHandler.getBoundAction(3))));
                }
            }
        } else if (keyPressed == KEY.MINION && FactionPlayerHandler.getOpt((PlayerEntity)Minecraft.func_71410_x().field_71439_g).map(FactionPlayerHandler::getLordLevel).orElse(0) > 0) {
            Minecraft.func_71410_x().func_147108_a((Screen)new SelectMinionTaskScreen());
        }
        if (this.suckKeyDown && !SUCK.func_151470_d()) {
            this.suckKeyDown = false;
            VampirismMod.dispatcher.sendToServer(new InputEventPacket("esb", ""));
        }
    }

    private KEY getPressedKeyBinding() {
        if (SUCK.func_151470_d()) {
            return KEY.SUCK;
        }
        if (ACTION.func_151470_d()) {
            return KEY.ACTION;
        }
        if (SKILL.func_151470_d()) {
            return KEY.SKILL;
        }
        if (VISION.func_151470_d()) {
            return KEY.VISION;
        }
        if (ACTION1.func_151470_d()) {
            return KEY.ACTION1;
        }
        if (ACTION2.func_151470_d()) {
            return KEY.ACTION2;
        }
        if (ACTION3.func_151470_d()) {
            return KEY.ACTION3;
        }
        if (MINION.func_151470_d()) {
            return KEY.MINION;
        }
        return KEY.UNKNOWN;
    }

    private void toggleBoundAction(@Nonnull IFactionPlayer player, @Nullable IAction action) {
        if (action == null) {
            player.getRepresentingPlayer().func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.action.not_bound", new Object[]{"/vampirism bind-action"}), true);
        } else if (!action.getFaction().equals(player.getFaction())) {
            player.getRepresentingPlayer().func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.action.only_faction", new Object[]{action.getFaction().getName()}), true);
        } else {
            VampirismMod.dispatcher.sendToServer(new InputEventPacket("ta", "" + action.getRegistryName()));
        }
    }

    public static enum KEY {
        SUCK,
        UNKNOWN,
        ACTION,
        SKILL,
        VISION,
        ACTION1,
        ACTION2,
        ACTION3,
        MINION;

    }
}

