/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.vampirism.mixin.client.BossOverlayGuiAccessor;
import de.teamlapen.vampirism.network.UpdateMultiBossInfoPacket;
import de.teamlapen.vampirism.world.DummyBossInfo;
import de.teamlapen.vampirism.world.MultiBossInfo;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.ClientBossInfo;
import net.minecraft.network.play.server.SUpdateBossInfoPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.BossInfo;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CustomBossInfoOverlay
extends AbstractGui {
    private static final ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("textures/gui/bars.png");
    private final Minecraft client;
    private final Map<UUID, MultiBossInfo> bossInfoMap = new LinkedHashMap<UUID, MultiBossInfo>();

    public CustomBossInfoOverlay() {
        this.client = Minecraft.func_71410_x();
    }

    public void clear() {
        this.bossInfoMap.clear();
    }

    @SubscribeEvent
    public void onRenderOverlayBoss(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.BOSSHEALTH) {
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableBlend();
            this.render(event.getMatrixStack());
            RenderSystem.disableBlend();
        }
    }

    public void read(UpdateMultiBossInfoPacket packet) {
        if (packet.getOperation() == SUpdateBossInfoPacket.Operation.ADD) {
            this.bossInfoMap.put(packet.getUniqueId(), new MultiBossInfo(packet));
        } else if (packet.getOperation() == SUpdateBossInfoPacket.Operation.REMOVE) {
            this.bossInfoMap.remove(packet.getUniqueId());
        } else {
            this.bossInfoMap.get(packet.getUniqueId()).updateFromPackage(packet);
        }
    }

    public void render(MatrixStack stack) {
        int i = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        int n = ((BossOverlayGuiAccessor)this.client.field_71456_v.func_184046_j()).getMapBossInfos().size();
        this.client.field_71466_p.getClass();
        int j = 12 + n * (10 + 9);
        for (MultiBossInfo value : this.bossInfoMap.values()) {
            int k = i / 2 - 91;
            MainWindow mainWindow = this.client.func_228018_at_();
            DummyBossInfo dummyBossInfo = new DummyBossInfo(value.getUniqueId(), value.getName());
            this.client.field_71466_p.getClass();
            RenderGameOverlayEvent.BossInfo event = ForgeHooksClient.bossBarRenderPre((MatrixStack)stack, (MainWindow)mainWindow, (ClientBossInfo)dummyBossInfo, (int)k, (int)j, (int)(10 + 9));
            if (!event.isCanceled()) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_BARS_TEXTURES);
                this.render(stack, k, j, value);
                ITextComponent itextcomponent = value.getName();
                int l = this.client.field_71466_p.func_238414_a_((ITextProperties)itextcomponent);
                int i1 = i / 2 - l / 2;
                int j1 = j - 9;
                this.client.field_71466_p.func_243246_a(stack, itextcomponent, (float)i1, (float)j1, 0xFFFFFF);
            }
            ForgeHooksClient.bossBarRenderPost((MatrixStack)stack, (MainWindow)this.client.func_228018_at_());
            if ((j += event.getIncrement()) < this.client.func_228018_at_().func_198087_p() / 3) continue;
            break;
        }
    }

    private void render(MatrixStack stack, int k, int j, MultiBossInfo value) {
        int width;
        int textureStart = 0;
        List<Color> s = value.getColors();
        Map<Color, Float> perc = value.getEntries();
        for (int i = 0; i < s.size() && textureStart < 182; textureStart += width, ++i) {
            Color color = s.get(i);
            width = (int)(perc.getOrDefault(color, Float.valueOf(0.0f)).floatValue() * 182.0f);
            if (i == s.size() - 1 && textureStart + width < 182) {
                width = 182 - textureStart;
            }
            RenderSystem.color4f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
            this.func_238474_b_(stack, k + textureStart, j, textureStart, BossInfo.Color.WHITE.ordinal() * 5 * 2 + 5, width, 5);
        }
        if (value.getOverlay() != BossInfo.Overlay.PROGRESS) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_238474_b_(stack, k, j, 0, 80 + (value.getOverlay().ordinal() - 1) * 5 * 2, 182, 5);
        }
    }
}

