/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.lib.lib.client.gui.widget.ScrollableArrayTextComponentList;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.AppearanceScreen;
import de.teamlapen.vampirism.client.render.entities.HunterMinionRenderer;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.AppearancePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class HunterMinionAppearanceScreen
extends AppearanceScreen<HunterMinionEntity> {
    private static final ITextComponent NAME = new TranslationTextComponent("gui.vampirism.minion_appearance");
    private int skinType;
    private int hatType;
    private boolean useLordSkin;
    private boolean isMinionSpecificSkin;
    private ScrollableArrayTextComponentList skinList;
    private ScrollableArrayTextComponentList hatList;
    private ExtendedButton skinButton;
    private ExtendedButton hatButton;
    private CheckboxButton useLordSkinButton;
    private TextFieldWidget nameWidget;
    private int normalSkinCount;
    private int minionSkinCount;

    public HunterMinionAppearanceScreen(HunterMinionEntity minion, Screen backScreen) {
        super(NAME, minion, backScreen);
    }

    @Override
    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.hatList.func_231045_a_(mouseX, mouseY, button, dragX, dragY) && !this.skinList.func_231045_a_(mouseX, mouseY, button, dragX, dragY)) {
            return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void func_231164_f_() {
        String name = this.nameWidget.func_146179_b();
        if (name.isEmpty()) {
            name = new TranslationTextComponent("text.vampirism.minion").toString() + ((HunterMinionEntity)this.entity).getMinionId().orElse(0);
        }
        VampirismMod.dispatcher.sendToServer(new AppearancePacket(((HunterMinionEntity)this.entity).func_145782_y(), name, this.skinType, this.hatType, (this.isMinionSpecificSkin ? 2 : 0) | (this.useLordSkin ? 1 : 0)));
        super.func_231164_f_();
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.nameWidget = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.guiLeft + 21, this.guiTop + 29, 98, 12, (ITextComponent)new TranslationTextComponent("gui.vampirism.minion_appearance.name")));
        this.nameWidget.func_146180_a(((HunterMinionEntity)this.entity).getMinionData().map(MinionData::getName).orElse("Minion"));
        this.nameWidget.func_146204_h(-1);
        this.nameWidget.func_146193_g(-1);
        this.nameWidget.func_146203_f(15);
        this.nameWidget.func_212954_a(this::onNameChanged);
        this.normalSkinCount = ((HunterMinionRenderer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)this.entity)).getHunterTextureCount();
        this.minionSkinCount = ((HunterMinionRenderer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)this.entity)).getMinionSpecificTextureCount();
        this.isMinionSpecificSkin = ((HunterMinionEntity)this.entity).hasMinionSpecificSkin();
        if (this.isMinionSpecificSkin && this.minionSkinCount > 0) {
            this.skinType %= this.minionSkinCount;
        } else {
            this.skinType %= this.normalSkinCount;
            this.isMinionSpecificSkin = false;
        }
        this.hatType = ((HunterMinionEntity)this.entity).getHatType();
        this.useLordSkin = ((HunterMinionEntity)this.entity).shouldRenderLordSkin();
        this.skinList = (ScrollableArrayTextComponentList)this.func_230480_a_((Widget)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 43 + 19, 99, 80, 20, this.normalSkinCount + this.minionSkinCount, (TextComponent)new TranslationTextComponent("gui.vampirism.minion_appearance.skin"), this::skin, this::previewSkin));
        this.hatList = (ScrollableArrayTextComponentList)this.func_230480_a_((Widget)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 64 + 19, 99, 60, 20, 3, (TextComponent)new TranslationTextComponent("gui.vampirism.minion_appearance.hat"), this::hat, this::previewHat));
        this.skinButton = (ExtendedButton)this.func_230480_a_((Widget)new ExtendedButton(this.skinList.field_230690_l_, this.skinList.field_230691_m_ - 20, this.skinList.func_230998_h_() + 1, 20, (ITextComponent)new StringTextComponent(""), b -> this.setSkinListVisibility(!this.skinList.field_230694_p_)));
        this.hatButton = (ExtendedButton)this.func_230480_a_((Widget)new ExtendedButton(this.hatList.field_230690_l_, this.hatList.field_230691_m_ - 20, this.hatList.func_230998_h_() + 1, 20, (ITextComponent)new StringTextComponent(""), b -> this.setHatListVisibility(!this.hatList.field_230694_p_)));
        this.useLordSkinButton = (CheckboxButton)this.func_230480_a_((Widget)new CheckboxButton(this.guiLeft + 20, this.guiTop + 86, 99, 20, (ITextComponent)new TranslationTextComponent("gui.vampirism.minion_appearance.use_lord_skin"), this.useLordSkin){

            public void func_230930_b_() {
                super.func_230930_b_();
                HunterMinionAppearanceScreen.this.useLordSkin = this.func_212942_a();
                ((HunterMinionEntity)HunterMinionAppearanceScreen.this.entity).setUseLordSkin(HunterMinionAppearanceScreen.this.useLordSkin);
            }
        });
        this.setSkinListVisibility(false);
        this.setHatListVisibility(false);
    }

    private void hat(int type) {
        this.hatType = type;
        ((HunterMinionEntity)this.entity).setHatType(this.hatType);
        this.setHatListVisibility(false);
    }

    private void onNameChanged(String newName) {
        ((HunterMinionEntity)this.entity).changeMinionName(newName);
    }

    private void previewHat(int type, boolean hovered) {
        if (hovered) {
            ((HunterMinionEntity)this.entity).setHatType(type);
        } else if (((HunterMinionEntity)this.entity).getHatType() == type) {
            ((HunterMinionEntity)this.entity).setHatType(this.hatType);
        }
    }

    private void previewSkin(int type, boolean hovered) {
        boolean minionSpecific;
        boolean bl = minionSpecific = type >= this.normalSkinCount;
        if (hovered) {
            ((HunterMinionEntity)this.entity).setHunterType(type, minionSpecific);
        } else if (((HunterMinionEntity)this.entity).getHunterType() == type && ((HunterMinionEntity)this.entity).hasMinionSpecificSkin() == minionSpecific) {
            ((HunterMinionEntity)this.entity).setHunterType(this.skinType, this.isMinionSpecificSkin);
        }
    }

    private void setHatListVisibility(boolean show) {
        this.hatButton.func_238482_a_((ITextComponent)this.hatList.func_230458_i_().func_230532_e_().func_240702_b_(" " + (this.hatType + 1)));
        this.hatList.field_230694_p_ = show;
        if (show) {
            this.skinList.field_230694_p_ = false;
        }
        this.useLordSkinButton.field_230694_p_ = !show;
    }

    private void setSkinListVisibility(boolean show) {
        this.skinButton.func_238482_a_((ITextComponent)this.skinList.func_230458_i_().func_230532_e_().func_240702_b_(" " + (this.skinType + 1)));
        this.skinList.field_230694_p_ = show;
        this.hatButton.field_230694_p_ = !show;
        boolean bl = this.useLordSkinButton.field_230694_p_ = !show;
        if (show) {
            this.hatList.field_230694_p_ = false;
        }
    }

    private void skin(int type) {
        boolean minionSpecific = type >= this.normalSkinCount;
        this.skinType = type;
        this.isMinionSpecificSkin = minionSpecific;
        ((HunterMinionEntity)this.entity).setHunterType(this.skinType, this.isMinionSpecificSkin);
        this.setSkinListVisibility(false);
    }
}

