/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.UpgradeMinionStatPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class MinionStatsScreen<T extends MinionData, Q extends MinionEntity<T>>
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("vampirism", "textures/gui/appearance.png");
    private static final ResourceLocation RESET = new ResourceLocation("vampirism", "textures/gui/reset.png");
    protected final Q entity;
    protected final int xSize = 256;
    protected final int ySize = 177;
    protected final int statCount;
    @Nullable
    protected final Screen backScreen;
    private final TranslationTextComponent textLevel = new TranslationTextComponent("text.vampirism.level");
    private final List<Button> statButtons = new ArrayList<Button>();
    protected int guiLeft;
    protected int guiTop;
    private Button reset;

    protected MinionStatsScreen(Q entity, int statCount, @Nullable Screen backScreen) {
        super((ITextComponent)new TranslationTextComponent("gui.vampirism.minion_stats"));
        assert (statCount > 0);
        this.entity = entity;
        this.statCount = statCount;
        this.backScreen = backScreen;
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(mStack);
        this.renderGuiBackground(mStack);
        this.drawTitle(mStack);
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        ((MinionEntity)this.entity).getMinionData().ifPresent(d -> this.renderStats(mStack, d));
    }

    public void func_231023_e_() {
        for (int i = 0; i < this.statCount; ++i) {
            int finalI = i;
            this.statButtons.get((int)i).field_230693_o_ = ((MinionEntity)this.entity).getMinionData().map(d -> this.isActive(d, finalI)).orElse(false);
            this.statButtons.get((int)i).field_230694_p_ = ((MinionEntity)this.entity).getMinionData().map(this::areButtonsVisible).orElse(false);
        }
        this.reset.field_230693_o_ = ((MinionEntity)this.entity).getMinionData().map(MinionData::hasUsedSkillPoints).orElse(false) != false && this.getOblivionPotion().isPresent();
    }

    protected abstract boolean areButtonsVisible(T var1);

    protected abstract int getRemainingStatPoints(T var1);

    protected void func_231160_c_() {
        this.statButtons.clear();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.func_230480_a_((Widget)new Button(this.guiLeft + this.xSize - 80 - 20, this.guiTop + 152, 80, 20, (ITextComponent)new TranslationTextComponent("gui.done"), context -> this.func_231175_as__()));
        if (this.backScreen != null) {
            this.func_230480_a_((Widget)new Button(this.guiLeft + 20, this.guiTop + 152, 80, 20, (ITextComponent)new TranslationTextComponent("gui.back"), context -> Minecraft.func_71410_x().func_147108_a(this.backScreen)));
        }
        for (int i = 0; i < this.statCount; ++i) {
            int finalI = i;
            Button button2 = (Button)this.func_230480_a_((Widget)new Button(this.guiLeft + 225, this.guiTop + 43 + 26 * i, 20, 20, (ITextComponent)new StringTextComponent("+"), b -> VampirismMod.dispatcher.sendToServer(new UpgradeMinionStatPacket(this.entity.func_145782_y(), finalI))));
            this.statButtons.add(button2);
            button2.field_230694_p_ = false;
        }
        this.reset = (Button)this.func_230480_a_((Widget)new ImageButton(this.guiLeft + 225, this.guiTop + 8, 20, 20, 0, 0, 20, RESET, 20, 40, context -> {
            VampirismMod.dispatcher.sendToServer(new UpgradeMinionStatPacket(this.entity.func_145782_y(), -1));
            this.getOblivionPotion().ifPresent(stack -> stack.func_190918_g(1));
        }, (button, matrixStack, mouseX, mouseY) -> this.func_238652_a_(matrixStack, button.func_230458_i_(), mouseX, mouseY), (ITextComponent)new TranslationTextComponent("text.vampirism.minion_screen.reset_stats", new Object[]{ModItems.oblivion_potion.func_200296_o()})){

            public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                if (this.field_230694_p_) {
                    boolean bl = this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
                    if (!this.field_230693_o_) {
                        RenderSystem.color4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                    }
                    super.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
                }
            }
        });
        this.reset.field_230693_o_ = false;
    }

    protected abstract boolean isActive(T var1, int var2);

    protected void renderGuiBackground(MatrixStack mStack) {
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        MinionStatsScreen.func_238464_a_((MatrixStack)mStack, (int)this.guiLeft, (int)this.guiTop, (int)this.func_230927_p_(), (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)256, (int)300);
    }

    protected void renderLevelRow(MatrixStack mStack, int current, int max) {
        this.field_230712_o_.func_243248_b(mStack, (ITextComponent)this.textLevel, (float)(this.guiLeft + 10), (float)(this.guiTop + 30), 0);
        this.field_230712_o_.func_238421_b_(mStack, current + "/" + max, (float)(this.guiLeft + 145), (float)(this.guiTop + 30), 0x404040);
        int remainingPoints = ((MinionEntity)this.entity).getMinionData().map(this::getRemainingStatPoints).orElse(0);
        if (remainingPoints > 0) {
            this.field_230712_o_.func_238421_b_(mStack, "(" + remainingPoints + ")", (float)(this.guiLeft + 228), (float)(this.guiTop + 30), 0x404040);
        }
        this.func_238465_a_(mStack, this.guiLeft + 10, this.guiLeft + 256 - 10, this.guiTop + 40, -265277392);
    }

    protected void renderStatRow(MatrixStack mStack, int i, TranslationTextComponent name, StringTextComponent value, int currentLevel, int maxLevel) {
        this.field_230712_o_.func_243248_b(mStack, (ITextComponent)name.func_240702_b_(":"), (float)(this.guiLeft + 10), (float)(this.guiTop + 50 + 26 * i), 0x404040);
        this.field_230712_o_.func_243248_b(mStack, (ITextComponent)value, (float)(this.guiLeft + 145), (float)(this.guiTop + 50 + 26 * i), 0x404040);
        this.field_230712_o_.func_238421_b_(mStack, UtilLib.translate("text.vampirism.level_short", new Object[0]) + ": " + currentLevel + "/" + maxLevel, (float)(this.guiLeft + 175), (float)(this.guiTop + 50 + 26 * i), 0x404040);
    }

    protected void renderStats(MatrixStack mStack, T data) {
    }

    private void drawTitle(MatrixStack mStack) {
        this.field_230712_o_.func_243246_a(mStack, this.field_230704_d_, (float)(this.guiLeft + 10), (float)(this.guiTop + 10), 0xFFFFFF);
    }

    private Optional<ItemStack> getOblivionPotion() {
        return Optional.ofNullable(((MinionEntity)this.entity).getMinionData().flatMap(data -> Optional.ofNullable(InventoryHelper.getFirst(data.getInventory(), ModItems.oblivion_potion))).orElse(InventoryHelper.getFirst((IInventory)this.field_230706_i_.field_71439_g.field_71071_by, ModItems.oblivion_potion)));
    }
}

