/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableArrayTextComponentList;
import de.teamlapen.lib.lib.client.gui.widget.ScrollableListWidget;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.client.gui.AppearanceScreen;
import de.teamlapen.vampirism.network.AppearancePacket;
import de.teamlapen.vampirism.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayerSpecialAttributes;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class VampirePlayerAppearanceScreen
extends AppearanceScreen<PlayerEntity> {
    private static final ITextComponent NAME = new TranslationTextComponent("gui.vampirism.appearance");
    private float[] color;
    private int fangType;
    private int eyeType;
    private boolean glowingEyes;
    private ScrollableListWidget<Pair<Integer, ITextComponent>> eyeList;
    private ScrollableListWidget<Pair<Integer, ITextComponent>> fangList;
    private ExtendedButton eyeButton;
    private ExtendedButton fangButton;
    private CheckboxButton glowingEyesButton;

    public VampirePlayerAppearanceScreen(@Nullable Screen backScreen) {
        super(NAME, Minecraft.func_71410_x().field_71439_g, backScreen);
    }

    @Override
    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.fangList.func_231045_a_(mouseX, mouseY, button, dragX, dragY) && !this.eyeList.func_231045_a_(mouseX, mouseY, button, dragX, dragY)) {
            return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void func_231164_f_() {
        VampirismMod.dispatcher.sendToServer(new AppearancePacket(((PlayerEntity)this.entity).func_145782_y(), "", this.fangType, this.eyeType, this.glowingEyes ? 1 : 0));
        super.func_231164_f_();
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        IPlayableFaction<IFactionPlayer<?>> f = VampirismPlayerAttributes.get((PlayerEntity)Minecraft.func_71410_x().field_71439_g).faction;
        this.color = f == null ? Color.gray.getRGBColorComponents(null) : f.getColor().getRGBColorComponents(null);
        VampirePlayerSpecialAttributes vampAtt = VampirismPlayerAttributes.get((PlayerEntity)this.field_230706_i_.field_71439_g).getVampSpecial();
        this.fangType = vampAtt.fangType;
        this.eyeType = vampAtt.eyeType;
        this.glowingEyes = vampAtt.glowingEyes;
        this.eyeList = (ScrollableListWidget)this.func_230480_a_((Widget)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 30 + 19, 99, 100, 20, 16, (TextComponent)new TranslationTextComponent("gui.vampirism.appearance.eye"), this::eye, this::hoverEye).scrollSpeed(2.0));
        this.fangList = (ScrollableListWidget)this.func_230480_a_((Widget)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 50 + 19, 99, 80, 20, 7, (TextComponent)new TranslationTextComponent("gui.vampirism.appearance.fang"), this::fang, this::hoverFang));
        this.eyeButton = (ExtendedButton)this.func_230480_a_((Widget)new ExtendedButton(this.eyeList.field_230690_l_, this.eyeList.field_230691_m_ - 20, this.eyeList.func_230998_h_() + 1, 20, (ITextComponent)new StringTextComponent(""), b -> this.setEyeListVisibility(!this.eyeList.field_230694_p_)));
        this.fangButton = (ExtendedButton)this.func_230480_a_((Widget)new ExtendedButton(this.fangList.field_230690_l_, this.fangList.field_230691_m_ - 20, this.fangList.func_230998_h_() + 1, 20, (ITextComponent)new StringTextComponent(""), b -> this.setFangListVisibility(!this.fangList.field_230694_p_)));
        this.glowingEyesButton = (CheckboxButton)this.func_230480_a_((Widget)new CheckboxButton(this.guiLeft + 20, this.guiTop + 70, 99, 20, (ITextComponent)new TranslationTextComponent("gui.vampirism.appearance.glowing_eye"), this.glowingEyes){

            public void func_230930_b_() {
                super.func_230930_b_();
                VampirePlayerAppearanceScreen.this.glowingEyes = this.func_212942_a();
                VampirePlayer.getOpt((PlayerEntity)VampirePlayerAppearanceScreen.this.entity).ifPresent(p -> p.setGlowingEyes(VampirePlayerAppearanceScreen.this.glowingEyes));
            }
        });
        this.setEyeListVisibility(false);
        this.setFangListVisibility(false);
    }

    @Override
    protected void renderGuiBackground(MatrixStack mStack) {
        GlStateManager.func_227702_d_((float)this.color[0], (float)this.color[1], (float)this.color[2], (float)1.0f);
        super.renderGuiBackground(mStack);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void eye(int eyeType) {
        VampirePlayer.getOpt((PlayerEntity)this.field_230706_i_.field_71439_g).ifPresent(vampire -> {
            this.eyeType = eyeType;
            vampire.setEyeType(this.eyeType);
            this.setEyeListVisibility(false);
        });
    }

    private void fang(int fangType) {
        VampirePlayer.getOpt((PlayerEntity)this.field_230706_i_.field_71439_g).ifPresent(vampire -> {
            this.fangType = fangType;
            vampire.setFangType(this.fangType);
            this.setFangListVisibility(false);
        });
    }

    private void hoverEye(int eyeType, boolean hovered) {
        VampirePlayer.getOpt((PlayerEntity)this.field_230706_i_.field_71439_g).ifPresent(vampire -> {
            if (hovered) {
                vampire.setEyeType(eyeType);
            } else if (vampire.getEyeType() == eyeType) {
                vampire.setEyeType(this.eyeType);
            }
        });
    }

    private void hoverFang(int fangType, boolean hovered) {
        VampirePlayer.getOpt((PlayerEntity)this.field_230706_i_.field_71439_g).ifPresent(vampire -> {
            if (hovered) {
                vampire.setFangType(fangType);
            } else if (vampire.getFangType() == fangType) {
                vampire.setFangType(this.fangType);
            }
        });
    }

    private void setEyeListVisibility(boolean show) {
        this.eyeButton.func_238482_a_((ITextComponent)this.eyeList.func_230458_i_().func_230532_e_().func_240702_b_(" " + (this.eyeType + 1)));
        this.eyeList.field_230694_p_ = show;
        this.fangButton.field_230694_p_ = !show;
        boolean bl = this.glowingEyesButton.field_230694_p_ = !show;
        if (show) {
            this.fangList.field_230694_p_ = false;
        }
    }

    private void setFangListVisibility(boolean show) {
        this.fangButton.func_238482_a_((ITextComponent)this.fangList.func_230458_i_().func_230532_e_().func_240702_b_(" " + (this.fangType + 1)));
        this.fangList.field_230694_p_ = show;
        boolean bl = this.glowingEyesButton.field_230694_p_ = !show;
        if (show) {
            this.eyeList.field_230694_p_ = false;
        }
    }
}

