/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.entities;

import de.teamlapen.vampirism.client.model.BasicHunterModel;
import de.teamlapen.vampirism.client.render.entities.DualBipedRenderer;
import de.teamlapen.vampirism.client.render.entities.HunterEquipmentModel;
import de.teamlapen.vampirism.client.render.layers.CloakLayer;
import de.teamlapen.vampirism.client.render.layers.HunterEquipmentLayer;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class BasicHunterRenderer
extends DualBipedRenderer<BasicHunterEntity, BasicHunterModel<BasicHunterEntity>> {
    private final Pair<ResourceLocation, Boolean> textureDefault = Pair.of((Object)new ResourceLocation("vampirism", "textures/entity/hunter_base1.png"), (Object)false);
    private final Pair<ResourceLocation, Boolean>[] textures;
    private final ResourceLocation textureCloak = new ResourceLocation("vampirism", "textures/entity/hunter_cloak.png");

    public BasicHunterRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new BasicHunterModel(false), new BasicHunterModel(true), 0.5f);
        this.func_177094_a(new HunterEquipmentLayer(this, entity -> entity.getLevel() < 2 || entity.isCrossbowInMainhand() ? HunterEquipmentModel.StakeType.ONLY : HunterEquipmentModel.StakeType.FULL, entity -> entity.getLevel() == 0 ? entity.getEntityTextureType() % 4 : -1));
        this.func_177094_a(new CloakLayer(this, this.textureCloak, entity -> entity.getLevel() > 0));
        this.textures = this.gatherTextures("textures/entity/hunter", true);
    }

    @Override
    protected Pair<ResourceLocation, Boolean> determineTextureAndModel(BasicHunterEntity entity) {
        int level = entity.getLevel();
        if (level > 0) {
            return this.textureDefault;
        }
        return this.textures[entity.getEntityTextureType() % this.textures.length];
    }
}

