/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public abstract class DualBipedRenderer<T extends MobEntity, M extends BipedModel<T>>
extends BipedRenderer<T, M> {
    private final M modelA;
    private final M modelB;
    private ResourceLocation currentTexture;

    public DualBipedRenderer(EntityRendererManager renderManagerIn, M modelBipedInA, M modelBipedInB, float shadowSize) {
        super(renderManagerIn, modelBipedInA, shadowSize);
        this.modelA = modelBipedInA;
        this.modelB = modelBipedInB;
    }

    public ResourceLocation func_110775_a(T entity) {
        return this.currentTexture != null ? this.currentTexture : super.func_110775_a(entity);
    }

    public final void func_225623_a_(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        Pair<ResourceLocation, Boolean> b = this.determineTextureAndModel(entityIn);
        this.currentTexture = (ResourceLocation)b.getLeft();
        this.field_77045_g = (Boolean)b.getRight() != false ? this.modelB : this.modelA;
        this.renderSelected(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected abstract Pair<ResourceLocation, Boolean> determineTextureAndModel(T var1);

    protected void renderSelected(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected Pair<ResourceLocation, Boolean>[] separateSlimTextures(Stream<ResourceLocation> set) {
        return (Pair[])set.map(r -> {
            boolean b = r.func_110623_a().endsWith("slim.png");
            return Pair.of((Object)r, (Object)b);
        }).toArray(Pair[]::new);
    }

    protected Pair<ResourceLocation, Boolean>[] gatherTextures(String dirPath, boolean required) {
        ArrayList hunterTextures = new ArrayList(Minecraft.func_71410_x().func_195551_G().func_199003_a(dirPath, s -> s.endsWith(".png")));
        Pair<ResourceLocation, Boolean>[] textures = this.separateSlimTextures(hunterTextures.stream().filter(r -> "vampirism".equals(r.func_110624_b())));
        if (textures.length == 0 && required) {
            throw new IllegalStateException("Must have at least one hunter texture: vampirism:" + dirPath + "/texture.png");
        }
        return textures;
    }
}

